/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.util.Optional;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.TestExecutionContext;
import org.antublue.test.engine.internal.descriptor.AbstractRunnableTestDescriptor;
import org.antublue.test.engine.internal.descriptor.RunnableParameterTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;

public final class RunnableClassTestDescriptor
extends AbstractRunnableTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunnableClassTestDescriptor.class);
    private final Class<?> testClass;

    public RunnableClassTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass) {
        super(uniqueId, displayName);
        this.testClass = testClass;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testClass));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public boolean isTest() {
        return false;
    }

    public boolean isContainer() {
        return true;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public void run() {
        TestExecutionContext testExecutionContext = this.getTestExecutionContext();
        ThrowableCollector throwableCollector = this.getThrowableCollector();
        EngineExecutionListener engineExecutionListener = testExecutionContext.getExecutionRequest().getEngineExecutionListener();
        engineExecutionListener.executionStarted((TestDescriptor)this);
        String testClassName = this.testClass.getName();
        Object testInstance = null;
        try {
            testInstance = this.testClass.getDeclaredConstructor(null).newInstance(null);
            testExecutionContext.setTestInstance(testInstance);
            LOGGER.trace("invoking [%s] @TestEngine.BeforeClass methods ...", (Object)testClassName);
            TestEngineReflectionUtils.getBeforeClassMethods(this.testClass).forEach(method -> {
                LOGGER.trace(String.format("invoking [%s] @TestEngine.BeforeClass method [%s] ...", testClassName, method.getName()));
                try {
                    method.invoke(null, (Object[])null);
                }
                finally {
                    this.flush();
                }
            });
        }
        catch (Throwable t) {
            throwableCollector.add(t);
            RunnableClassTestDescriptor.resolve(t).printStackTrace();
        }
        if (throwableCollector.isEmpty()) {
            this.getChildren(RunnableParameterTestDescriptor.class).forEach(runnableParameterTestDescriptor -> {
                runnableParameterTestDescriptor.setTestExecutionContext(testExecutionContext);
                runnableParameterTestDescriptor.run();
                throwableCollector.addAll(runnableParameterTestDescriptor.getThrowableCollector());
            });
        }
        try {
            LOGGER.trace("invoking [%s] @TestEngine.AfterClass methods ...", (Object)testClassName);
            TestEngineReflectionUtils.getAfterClassMethods(this.testClass).forEach(method -> {
                LOGGER.trace(String.format("invoking [%s] @TestEngine.AfterClass method [%s] ...", testClassName, method.getName()));
                try {
                    method.invoke(null, (Object[])null);
                }
                finally {
                    this.flush();
                }
            });
        }
        catch (Throwable t) {
            throwableCollector.add(t);
            RunnableClassTestDescriptor.resolve(t).printStackTrace();
        }
        if (throwableCollector.isEmpty()) {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)throwableCollector.getFirst().get()));
        }
        testExecutionContext.setTestInstance(null);
        this.getTestExecutionContext().getCountDownLatch().countDown();
    }
}

