/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery.resolver;

import java.util.concurrent.atomic.AtomicInteger;
import org.antublue.test.engine.internal.TestDescriptorUtils;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.RunnableClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.RunnableMethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.RunnableParameterTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class ClassSelectorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassSelectorResolver.class);

    public void resolve(ClassSelector classSelector, EngineDescriptor engineDescriptor) {
        LOGGER.trace("resolve [%s]", (Object)classSelector.getClassName());
        UniqueId engineDescriptorUniqueId = engineDescriptor.getUniqueId();
        Class clazz = classSelector.getJavaClass();
        LOGGER.trace("  class [%s]", (Object)clazz.getName());
        UniqueId classDescriptorUniqueId = engineDescriptorUniqueId.append("class", clazz.getName());
        RunnableClassTestDescriptor testEngineClassTestDescriptor = TestDescriptorUtils.createClassTestDescriptor(classDescriptorUniqueId, clazz);
        engineDescriptor.addChild((TestDescriptor)testEngineClassTestDescriptor);
        AtomicInteger index = new AtomicInteger();
        TestEngineReflectionUtils.getParameters(clazz).forEach(parameter -> {
            UniqueId parameterDescriptoruniqueId = classDescriptorUniqueId.append("parameter", String.valueOf(index.get()));
            RunnableParameterTestDescriptor testEngineParameterTestDescriptor = TestDescriptorUtils.createParameterTestDescriptor(parameterDescriptoruniqueId, clazz, parameter);
            testEngineClassTestDescriptor.addChild((TestDescriptor)testEngineParameterTestDescriptor);
            TestEngineReflectionUtils.getTestMethods(clazz).forEach(method -> {
                UniqueId uniqueId = parameterDescriptoruniqueId.append("method", method.getName());
                RunnableMethodTestDescriptor methodTestDescriptor = TestDescriptorUtils.createMethodTestDescriptor(uniqueId, clazz, parameter, method);
                testEngineParameterTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
            });
            testEngineParameterTestDescriptor.prune();
            index.incrementAndGet();
        });
    }
}

