/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery.resolver;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.TestDescriptorUtils;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.RunnableClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.RunnableMethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.RunnableParameterTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class MethodSelectorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodSelectorResolver.class);
    private static final Predicate<Class<?>> IS_TEST_CLASS = clazz -> {
        if (clazz.isAnnotationPresent(TestEngine.BaseClass.class) || clazz.isAnnotationPresent(TestEngine.Disabled.class)) {
            return false;
        }
        int modifiers = clazz.getModifiers();
        return !Modifier.isAbstract(modifiers) && !TestEngineReflectionUtils.getTestMethods(clazz).isEmpty();
    };

    public void resolve(MethodSelector methodSelector, EngineDescriptor engineDescriptor) {
        LOGGER.trace("resolve [%s]", (Object)methodSelector.getJavaMethod().getName());
        UniqueId engineDescriptorUniqueId = engineDescriptor.getUniqueId();
        Class clazz = methodSelector.getJavaClass();
        Method method = methodSelector.getJavaMethod();
        UniqueId classDescriptorUniqueId = engineDescriptorUniqueId.append("class", clazz.getName());
        RunnableClassTestDescriptor testEngineClassTestDescriptor = TestDescriptorUtils.createClassTestDescriptor(classDescriptorUniqueId, clazz);
        AtomicInteger index = new AtomicInteger();
        TestEngineReflectionUtils.getParameters(clazz).forEach(parameter -> {
            UniqueId uniqueId = classDescriptorUniqueId.append("parameter", String.valueOf(index.get()));
            RunnableParameterTestDescriptor testEngineParameterTestDescriptor = TestDescriptorUtils.createParameterTestDescriptor(uniqueId, clazz, parameter);
            uniqueId = uniqueId.append("method", method.getName());
            RunnableMethodTestDescriptor methodTestDescriptor = TestDescriptorUtils.createMethodTestDescriptor(uniqueId, clazz, parameter, method);
            uniqueId = uniqueId.removeLastSegment();
            testEngineParameterTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
            uniqueId.removeLastSegment();
            testEngineClassTestDescriptor.addChild((TestDescriptor)testEngineParameterTestDescriptor);
            engineDescriptor.addChild((TestDescriptor)testEngineClassTestDescriptor);
            index.incrementAndGet();
        });
    }
}

