/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery.resolver;

import java.lang.reflect.Method;
import java.util.List;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.internal.TestDescriptorUtils;
import org.antublue.test.engine.internal.TestEngineException;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.RunnableClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.RunnableMethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.RunnableParameterTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.Cast;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class UniqueIdSelectorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(UniqueIdSelectorResolver.class);

    public void resolve(UniqueIdSelector uniqueIdSelector, EngineDescriptor engineDescriptor) {
        LOGGER.trace("resolve [%s]", (Object)uniqueIdSelector.getUniqueId());
        String className = null;
        try {
            UniqueId selectorUniqueId = uniqueIdSelector.getUniqueId();
            LOGGER.trace("selectorUniqueId [%s]", (Object)selectorUniqueId);
            UniqueId.Segment segment = selectorUniqueId.getLastSegment();
            if ("parameter".equals(segment.getType())) {
                LOGGER.trace("parameter [%s] selected", (Object)segment.getValue());
                UniqueId classUniqueId = selectorUniqueId.removeLastSegment();
                UniqueId.Segment classSegment = classUniqueId.getLastSegment();
                className = classSegment.getValue();
                LOGGER.trace("className [%s]", (Object)className);
                Class<?> clazz = Class.forName(className);
                RunnableClassTestDescriptor classTestDescriptor = engineDescriptor.findByUniqueId(classUniqueId).map(testDescriptor -> (RunnableClassTestDescriptor)Cast.cast(testDescriptor)).orElseGet(() -> TestDescriptorUtils.createClassTestDescriptor(classUniqueId, clazz));
                List<Parameter> parameters = TestEngineReflectionUtils.getParameters(clazz);
                Parameter parameter = parameters.get(Integer.parseInt(segment.getValue()));
                RunnableParameterTestDescriptor parameterTestDescriptor = classTestDescriptor.findByUniqueId(selectorUniqueId).map(testDescriptor -> (RunnableParameterTestDescriptor)Cast.cast(testDescriptor)).orElseGet(() -> TestDescriptorUtils.createParameterTestDescriptor(selectorUniqueId, clazz, parameter));
                List<Method> methods = TestEngineReflectionUtils.getTestMethods(clazz);
                for (Method method : methods) {
                    UniqueId methodUniqueId = selectorUniqueId.append("method", method.getName());
                    RunnableMethodTestDescriptor methodTestDescriptor = TestDescriptorUtils.createMethodTestDescriptor(methodUniqueId, clazz, parameter, method);
                    parameterTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
                }
                classTestDescriptor.addChild((TestDescriptor)parameterTestDescriptor);
                engineDescriptor.addChild((TestDescriptor)classTestDescriptor);
            } else if ("class".equals(segment.getType())) {
                className = segment.getValue();
                LOGGER.trace("className [%s]", (Object)className);
                Class<?> clazz = Class.forName(className);
                RunnableClassTestDescriptor classTestDescriptor = engineDescriptor.findByUniqueId(selectorUniqueId).map(testDescriptor -> (RunnableClassTestDescriptor)Cast.cast(testDescriptor)).orElseGet(() -> TestDescriptorUtils.createClassTestDescriptor(selectorUniqueId, clazz));
                List<Parameter> parameters = TestEngineReflectionUtils.getParameters(clazz);
                for (int i = 0; i < parameters.size(); ++i) {
                    Parameter parameter = parameters.get(i);
                    UniqueId parameterUniqueId = selectorUniqueId.append("parameter", String.valueOf(i));
                    RunnableParameterTestDescriptor parameterTestDescriptor = TestDescriptorUtils.createParameterTestDescriptor(parameterUniqueId, clazz, parameter);
                    List<Method> methods = TestEngineReflectionUtils.getTestMethods(clazz);
                    for (Method method : methods) {
                        UniqueId methodUniqueId = parameterUniqueId.append("method", method.getName());
                        RunnableMethodTestDescriptor methodTestDescriptor = TestDescriptorUtils.createMethodTestDescriptor(methodUniqueId, clazz, parameter, method);
                        parameterTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
                    }
                    classTestDescriptor.addChild((TestDescriptor)parameterTestDescriptor);
                }
                engineDescriptor.addChild((TestDescriptor)classTestDescriptor);
            }
        }
        catch (ClassNotFoundException e) {
            throw new TestEngineException(String.format("Class [%s] not found", className), e);
        }
    }
}

