/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.experimental;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.antublue.test.engine.TestEngine;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.internal.TestDescriptorUtils;
import org.antublue.test.engine.internal.TestEngineConfiguration;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.TestEngineTestDescriptorStore;
import org.antublue.test.engine.internal.descriptor.RunnableClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.RunnableEngineDescriptor;
import org.antublue.test.engine.internal.descriptor.RunnableMethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.RunnableParameterTestDescriptor;
import org.antublue.test.engine.internal.util.AnsiColor;
import org.antublue.test.engine.internal.util.Cast;
import org.antublue.test.engine.internal.util.HumanReadableTime;
import org.antublue.test.engine.internal.util.Switch;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class TestEngineConsoleDisplayNameTestExecutionListener
implements TestExecutionListener {
    private static final String BANNER = "Antu" + AnsiColor.BLUE_BOLD_BRIGHT.apply("BLUE") + " Test Engine " + TestEngine.VERSION;
    private static final String INFO = AnsiColor.WHITE_BRIGHT.apply("[") + AnsiColor.BLUE_BOLD.apply("INFO") + AnsiColor.WHITE_BRIGHT.apply("]") + " ";
    private static final String TEST = AnsiColor.WHITE_BRIGHT.apply("TEST");
    private static final String ABORT = AnsiColor.YELLOW_BOLD.apply("ABORT");
    private static final String FAIL = AnsiColor.RED_BOLD.apply("FAIL");
    private static final String PASS = AnsiColor.GREEN_BOLD.apply("PASS");
    private static final String SEPARATOR = AnsiColor.WHITE_BRIGHT.apply("------------------------------------------------------------------------");
    private final boolean detailedOutput;
    private final boolean logTestMessages;
    private final boolean logPassMessages;
    private final Summary summary = new Summary();

    public TestEngineConsoleDisplayNameTestExecutionListener() {
        this.detailedOutput = TestEngineConfiguration.getInstance().get("antublue.test.engine.console.output").map(value -> {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (NumberFormatException e) {
                return true;
            }
        }).orElse(true);
        this.logTestMessages = TestEngineConfiguration.getInstance().get("antublue.test.engine.experimental.log.test.messages").map(value -> {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (NumberFormatException e) {
                return true;
            }
        }).orElse(true);
        this.logPassMessages = TestEngineConfiguration.getInstance().get("antublue.test.engine.experimental.log.pass.messages").map(value -> {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (NumberFormatException e) {
                return true;
            }
        }).orElse(true);
    }

    public boolean hasFailures() {
        if (this.summary.getTestClassCount() == 0L) {
            return true;
        }
        return this.summary.getTestClassesFailedCount() + this.summary.getParametersFailedCount() + this.summary.getTestsFailedCount() > 0L;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.summary.testPlanExecutionStarted(testPlan);
        testPlan.getRoots().forEach(testIdentifier -> {
            TestDescriptor testDescriptor = TestEngineTestDescriptorStore.getInstance().get(testIdentifier.getUniqueIdObject()).orElse(null);
            if (testDescriptor != null) {
                TestDescriptorUtils.trace(testDescriptor);
            }
        });
        System.out.println(INFO + SEPARATOR);
        System.out.println(INFO + BANNER);
        System.out.println(INFO + SEPARATOR);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        TestDescriptor testDescriptor = TestEngineTestDescriptorStore.getInstance().get(testIdentifier.getUniqueIdObject()).orElse(null);
        this.summary.executionStarted(testDescriptor);
        StringBuilder stringBuilder = new StringBuilder();
        Switch.switchType(testDescriptor, Switch.switchCase(RunnableEngineDescriptor.class, consumer -> {}), Switch.switchCase(RunnableClassTestDescriptor.class, consumer -> {
            String className;
            RunnableClassTestDescriptor classTestDescriptor = (RunnableClassTestDescriptor)Cast.cast(testDescriptor);
            Class<?> testClass = classTestDescriptor.getTestClass();
            String testClassDisplayName = TestEngineReflectionUtils.getDisplayName(testClass);
            if (!testClassDisplayName.equals(className = testClass.getName())) {
                testClassDisplayName = className + " (" + testClassDisplayName + ")";
            }
            if (this.logTestMessages) {
                stringBuilder.append(TEST).append(" | ").append(testClassDisplayName);
            }
        }), Switch.switchCase(RunnableParameterTestDescriptor.class, consumer -> {
            if (this.logTestMessages) {
                String className;
                RunnableParameterTestDescriptor parameterTestDescriptor = (RunnableParameterTestDescriptor)Cast.cast(testDescriptor);
                Class<?> testClass = parameterTestDescriptor.getTestClass();
                String testClassDisplayName = TestEngineReflectionUtils.getDisplayName(testClass);
                if (!testClassDisplayName.equals(className = testClass.getName())) {
                    testClassDisplayName = className + " (" + testClassDisplayName + ")";
                }
                Parameter testParameter = parameterTestDescriptor.getTestParameter();
                String testParameterName = testParameter.name();
                stringBuilder.append(TEST).append(" | ").append(testParameterName).append(" | ").append(testClassDisplayName);
            }
        }), Switch.switchCase(RunnableMethodTestDescriptor.class, consumer -> {
            if (this.logTestMessages) {
                String methodName;
                String className;
                RunnableMethodTestDescriptor methodTestDescriptor = (RunnableMethodTestDescriptor)Cast.cast(testDescriptor);
                Class<?> testClass = methodTestDescriptor.getTestClass();
                String testClassDisplayName = TestEngineReflectionUtils.getDisplayName(testClass);
                if (!testClassDisplayName.equals(className = testClass.getName())) {
                    testClassDisplayName = className + " (" + testClassDisplayName + ")";
                }
                Parameter testParameter = methodTestDescriptor.getTestParameter();
                String testParameterName = testParameter.name();
                Method testMethod = methodTestDescriptor.getTestMethod();
                String testMethodDisplayName = TestEngineReflectionUtils.getDisplayName(testMethod);
                testMethodDisplayName = !testMethodDisplayName.equals(methodName = testMethod.getName()) ? methodName + "() (" + testMethodDisplayName + ")" : methodName + "()";
                stringBuilder.append(TEST).append(" | ").append(testParameterName).append(" | ").append(testClassDisplayName).append(" ").append(testMethodDisplayName);
            }
        }));
        if (this.detailedOutput && stringBuilder.length() > 0) {
            System.out.println(INFO + Thread.currentThread().getName() + " | " + stringBuilder);
        }
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        TestDescriptor testDescriptor = TestEngineTestDescriptorStore.getInstance().get(testIdentifier.getUniqueIdObject()).orElse(null);
        this.summary.executionSkipped(testDescriptor, reason);
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        TestDescriptor testDescriptor = TestEngineTestDescriptorStore.getInstance().get(testIdentifier.getUniqueIdObject()).orElse(null);
        this.summary.executionFinished(testDescriptor, testExecutionResult);
        StringBuilder stringBuilder = new StringBuilder();
        Switch.switchType(testDescriptor, Switch.switchCase(RunnableEngineDescriptor.class, consumer -> {}), Switch.switchCase(RunnableClassTestDescriptor.class, consumer -> {
            if (this.logPassMessages) {
                String className;
                RunnableClassTestDescriptor classTestDescriptor = (RunnableClassTestDescriptor)Cast.cast(testDescriptor);
                Class<?> testClass = classTestDescriptor.getTestClass();
                String testClassDisplayName = TestEngineReflectionUtils.getDisplayName(testClass);
                if (!testClassDisplayName.equals(className = testClass.getName())) {
                    testClassDisplayName = className + " (" + testClassDisplayName + ")";
                }
                stringBuilder.append("%s | ").append(testClassDisplayName);
            }
        }), Switch.switchCase(RunnableParameterTestDescriptor.class, consumer -> {
            if (this.logPassMessages) {
                String className;
                RunnableParameterTestDescriptor parameterTestDescriptor = (RunnableParameterTestDescriptor)Cast.cast(testDescriptor);
                Class<?> testClass = parameterTestDescriptor.getTestClass();
                String testClassDisplayName = TestEngineReflectionUtils.getDisplayName(testClass);
                if (!testClassDisplayName.equals(className = testClass.getName())) {
                    testClassDisplayName = className + " (" + testClassDisplayName + ")";
                }
                Parameter testParameter = parameterTestDescriptor.getTestParameter();
                String testParameterName = testParameter.name();
                stringBuilder.append("%s | ").append(testParameterName).append(" | ").append(testClassDisplayName);
            }
        }), Switch.switchCase(RunnableMethodTestDescriptor.class, consumer -> {
            if (this.logPassMessages) {
                String methodName;
                String className;
                RunnableMethodTestDescriptor methodTestDescriptor = (RunnableMethodTestDescriptor)Cast.cast(testDescriptor);
                Class<?> testClass = methodTestDescriptor.getTestClass();
                String testClassDisplayName = TestEngineReflectionUtils.getDisplayName(testClass);
                if (!testClassDisplayName.equals(className = testClass.getName())) {
                    testClassDisplayName = className + " (" + testClassDisplayName + ")";
                }
                Parameter testParameter = methodTestDescriptor.getTestParameter();
                String testParameterName = testParameter.name();
                Method testMethod = methodTestDescriptor.getTestMethod();
                String testMethodDisplayName = TestEngineReflectionUtils.getDisplayName(testMethod);
                testMethodDisplayName = !testMethodDisplayName.equals(methodName = testMethod.getName()) ? methodName + "() (" + testMethodDisplayName + ")" : methodName + "()";
                stringBuilder.append("%s | ").append(testParameterName).append(" | ").append(testClassDisplayName).append(" ").append(testMethodDisplayName);
            }
        }));
        if (stringBuilder.length() > 0) {
            TestExecutionResult.Status status = testExecutionResult.getStatus();
            String string = null;
            switch (status) {
                case ABORTED: {
                    string = String.format(stringBuilder.toString(), ABORT);
                    break;
                }
                case FAILED: {
                    string = String.format(stringBuilder.toString(), FAIL);
                    break;
                }
                case SUCCESSFUL: {
                    string = String.format(stringBuilder.toString(), PASS);
                    break;
                }
            }
            if (this.detailedOutput && string != null) {
                System.out.println(INFO + Thread.currentThread().getName() + " | " + string);
            }
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.summary.testPlanExecutionFinished(testPlan);
        System.out.println(INFO + SEPARATOR);
        System.out.println(INFO + BANNER + " Summary");
        System.out.println(INFO + SEPARATOR);
        if (this.summary.getTestClassCount() != 0L) {
            long column1Width = this.getColumnWith(this.summary.getTestClassCount(), this.summary.getParametersFoundCount(), this.summary.getTestsFoundCount());
            long column2Width = this.getColumnWith(this.summary.getTestClassesSucceededCount(), this.summary.getParametersSucceededCount(), this.summary.getTestsSucceededCount());
            long column3Width = this.getColumnWith(this.summary.getTestClassesFailedCount(), this.summary.getParametersFailedCount(), this.summary.getTestsFailedCount());
            long column4Width = this.getColumnWith(this.summary.getTestClassesSkippedCount(), this.summary.getParametersSkippedCount(), this.summary.getTestsSkippedCount());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(INFO).append(AnsiColor.WHITE_BRIGHT.apply("Test Classes")).append("    : ").append(this.pad(this.summary.getTestClassCount(), column1Width)).append(", ").append(AnsiColor.GREEN_BOLD_BRIGHT.apply("PASSED")).append(" : ").append(this.pad(this.summary.getTestClassesSucceededCount(), column2Width)).append(", ").append(AnsiColor.RED_BOLD_BRIGHT.apply("FAILED")).append(" : ").append(this.pad(this.summary.getTestClassesFailedCount(), column3Width)).append(", ").append(AnsiColor.YELLOW_BOLD_BRIGHT.apply("SKIPPED")).append(" : ").append(this.pad(this.summary.getTestClassesSkippedCount(), column4Width));
            System.out.println(stringBuilder);
            stringBuilder.setLength(0);
            stringBuilder.append(INFO).append(AnsiColor.WHITE_BRIGHT.apply("Test Parameters")).append(" : ").append(this.pad(this.summary.getParametersFoundCount(), column1Width)).append(", ").append(AnsiColor.GREEN_BOLD_BRIGHT.apply("PASSED")).append(" : ").append(this.pad(this.summary.getParametersSucceededCount(), column2Width)).append(", ").append(AnsiColor.RED_BOLD_BRIGHT.apply("FAILED")).append(" : ").append(this.pad(this.summary.getParametersFailedCount(), column3Width)).append(", ").append(AnsiColor.YELLOW_BOLD_BRIGHT.apply("SKIPPED")).append(" : ").append(this.pad(this.summary.getParametersSkippedCount(), column4Width));
            System.out.println(stringBuilder);
            stringBuilder.setLength(0);
            stringBuilder.append(INFO).append(AnsiColor.WHITE_BRIGHT.apply("Test Methods")).append("    : ").append(this.pad(this.summary.getTestsFoundCount(), column1Width)).append(", ").append(AnsiColor.GREEN_BOLD_BRIGHT.apply("PASSED")).append(" : ").append(this.pad(this.summary.getTestsSucceededCount(), column2Width)).append(", ").append(AnsiColor.RED_BOLD_BRIGHT.apply("FAILED")).append(" : ").append(this.pad(this.summary.getTestsFailedCount(), column3Width)).append(", ").append(AnsiColor.YELLOW_BOLD_BRIGHT.apply("SKIPPED")).append(" : ").append(this.pad(this.summary.getTestsSkippedCount(), column4Width));
            System.out.println(stringBuilder);
        } else {
            System.out.println(INFO + AnsiColor.RED_BOLD_BRIGHT.apply("NO TESTS FOUND"));
        }
        System.out.println(INFO + SEPARATOR);
        if (this.hasFailures()) {
            System.out.println(INFO + AnsiColor.RED_BOLD_BRIGHT.apply("FAILED"));
        } else {
            System.out.println(INFO + AnsiColor.GREEN_BOLD.apply("PASSED"));
        }
        long elapsedTime = this.summary.getTimeFinished() - this.summary.getTimeStarted();
        System.out.println(INFO + SEPARATOR);
        System.out.println(INFO + "Total Test Time : " + HumanReadableTime.toHumanReadable(elapsedTime, false));
        System.out.println(INFO + "Finished At     : " + HumanReadableTime.now());
        if (!this.hasFailures()) {
            System.out.println(INFO + SEPARATOR);
        }
    }

    private long getColumnWith(long ... values) {
        long width = 0L;
        for (long value : values) {
            width = Math.max((long)String.valueOf(value).length(), width);
        }
        return width;
    }

    private String pad(long value, long width) {
        String stringValue = String.valueOf(value);
        StringBuilder paddingStringBuilder = new StringBuilder();
        while ((long)(paddingStringBuilder.length() + stringValue.length()) < width) {
            paddingStringBuilder.append(" ");
        }
        return paddingStringBuilder.append(stringValue).toString();
    }

    private static class Summary {
        private long startMilliseconds;
        private long finishedMilliseconds;
        private final Set<Class<?>> testClasses = Collections.synchronizedSet(new HashSet());
        private final AtomicLong testClassesFound = new AtomicLong();
        private final AtomicLong testClassesSuccess = new AtomicLong();
        private final AtomicLong testClassesFailed = new AtomicLong();
        private final AtomicLong testClassesSkipped = new AtomicLong();
        private final AtomicLong parametersFound = new AtomicLong();
        private final AtomicLong parametersSuccess = new AtomicLong();
        private final AtomicLong parametersFailed = new AtomicLong();
        private final AtomicLong parametersSkipped = new AtomicLong();
        private final AtomicLong methodsFound = new AtomicLong();
        private final AtomicLong methodsSuccess = new AtomicLong();
        private final AtomicLong methodsFailed = new AtomicLong();
        private final AtomicLong methodsSkipped = new AtomicLong();

        public long getTimeStarted() {
            return this.startMilliseconds;
        }

        public long getTestClassCount() {
            return this.testClassesFound.get();
        }

        public long getTestClassesSucceededCount() {
            return this.testClassesSuccess.get();
        }

        public long getTestClassesFailedCount() {
            return this.testClassesFailed.get();
        }

        public long getTestClassesSkippedCount() {
            return this.testClassesSkipped.get();
        }

        public long getParametersFoundCount() {
            return this.parametersFound.get();
        }

        public long getParametersSucceededCount() {
            return this.parametersSuccess.get();
        }

        public long getParametersFailedCount() {
            return this.parametersFailed.get();
        }

        public long getParametersSkippedCount() {
            return this.parametersSkipped.get();
        }

        public long getTestsFoundCount() {
            return this.methodsFound.get();
        }

        public long getTestsSucceededCount() {
            return this.methodsSuccess.get();
        }

        public long getTestsFailedCount() {
            return this.methodsFailed.get();
        }

        public long getTestsSkippedCount() {
            return this.methodsSkipped.get();
        }

        public long getTimeFinished() {
            return this.finishedMilliseconds;
        }

        public void testPlanExecutionStarted(TestPlan testPlan) {
            this.finishedMilliseconds = this.startMilliseconds = System.currentTimeMillis();
        }

        public void executionStarted(TestDescriptor testDescriptor) {
            if (testDescriptor instanceof RunnableClassTestDescriptor) {
                this.testClasses.add(((RunnableClassTestDescriptor)testDescriptor).getTestClass());
                this.testClassesFound.set(this.testClasses.size());
                return;
            }
            if (testDescriptor instanceof RunnableParameterTestDescriptor) {
                this.parametersFound.incrementAndGet();
                return;
            }
            if (testDescriptor instanceof RunnableMethodTestDescriptor) {
                this.methodsFound.incrementAndGet();
            }
        }

        public void executionSkipped(TestDescriptor testDescriptor, String reason) {
            if (testDescriptor instanceof RunnableParameterTestDescriptor) {
                this.parametersFound.incrementAndGet();
                this.parametersSkipped.incrementAndGet();
                return;
            }
            if (testDescriptor instanceof RunnableMethodTestDescriptor) {
                this.methodsFound.incrementAndGet();
                this.methodsSkipped.incrementAndGet();
            }
        }

        public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
            TestExecutionResult.Status status;
            if (testDescriptor instanceof RunnableClassTestDescriptor) {
                TestExecutionResult.Status status2 = testExecutionResult.getStatus();
                switch (status2) {
                    case SUCCESSFUL: {
                        this.testClassesSuccess.incrementAndGet();
                        break;
                    }
                    case FAILED: {
                        this.testClassesFailed.incrementAndGet();
                        break;
                    }
                    case ABORTED: {
                        this.testClassesSkipped.incrementAndGet();
                    }
                }
                return;
            }
            if (testDescriptor instanceof RunnableParameterTestDescriptor) {
                status = testExecutionResult.getStatus();
                switch (status) {
                    case SUCCESSFUL: {
                        this.parametersSuccess.incrementAndGet();
                        break;
                    }
                    case FAILED: {
                        this.parametersFailed.incrementAndGet();
                        break;
                    }
                    case ABORTED: {
                        this.parametersSkipped.incrementAndGet();
                    }
                }
            }
            if (testDescriptor instanceof RunnableMethodTestDescriptor) {
                status = testExecutionResult.getStatus();
                switch (status) {
                    case SUCCESSFUL: {
                        this.methodsSuccess.incrementAndGet();
                        break;
                    }
                    case FAILED: {
                        this.methodsFailed.incrementAndGet();
                        break;
                    }
                    case ABORTED: {
                        this.methodsSkipped.incrementAndGet();
                    }
                }
            }
        }

        public void testPlanExecutionFinished(TestPlan testPlan) {
            this.finishedMilliseconds = System.currentTimeMillis();
        }
    }
}

