/*
 * Copyright 2022-2023 Douglas Hoard
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.antublue.test.engine.internal.descriptor;

import org.antublue.test.engine.internal.TestExecutionContext;

/**
 * Class to implement a RunnableAdapter to test a class test descriptor in a Thread
 */
public final class RunnableAdapter implements Runnable {

    private final ClassTestDescriptor classTestDescriptor;
    private final TestExecutionContext testExecutionContext;

    /**
     * Constructor
     *
     * @param classTestDescriptor
     * @param testExecutionContext
     */
    public RunnableAdapter(
            ClassTestDescriptor classTestDescriptor, TestExecutionContext testExecutionContext) {
        this.testExecutionContext = testExecutionContext;
        this.classTestDescriptor = classTestDescriptor;
    }

    @Override
    public void run() {
        try {
            classTestDescriptor.execute(testExecutionContext);
        } catch (Throwable t) {
            t.printStackTrace();
        }
    }
}
