/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;
import org.antublue.test.engine.internal.TestExecutionContext;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;

abstract class ExtendedAbstractTestDescriptor
extends AbstractTestDescriptor {
    private final ThrowableCollector throwableCollector = new ThrowableCollector();

    protected ExtendedAbstractTestDescriptor(UniqueId uniqueId, String displayName) {
        super(uniqueId, displayName);
    }

    public <T> List<T> getChildren(Class<T> clazz) {
        return this.getChildren().stream().map(testDescriptor -> testDescriptor).collect(Collectors.toList());
    }

    protected ThrowableCollector getThrowableCollector() {
        return this.throwableCollector;
    }

    protected static Throwable resolve(Throwable t) {
        if (t instanceof RuntimeException) {
            t = t.getCause();
        }
        if (t instanceof InvocationTargetException) {
            return t.getCause();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            PrintStream printStream2 = System.err;
            synchronized (printStream2) {
                System.out.flush();
                System.err.flush();
            }
        }
    }

    public abstract void execute(TestExecutionContext var1);

    public void skip(TestExecutionContext testExecutionContext) {
        this.getChildren(ExtendedAbstractTestDescriptor.class).forEach(testDescriptor -> testDescriptor.skip(testExecutionContext));
        testExecutionContext.getExecutionRequest().getEngineExecutionListener().executionSkipped((TestDescriptor)this, "Parent failures");
    }
}

