/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.antublue.test.engine.internal.TestEngineConfiguration;
import org.antublue.test.engine.internal.TestEngineException;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ParameterTestDescriptor;
import org.antublue.test.engine.internal.discovery.resolver.ClassSelectorResolver;
import org.antublue.test.engine.internal.discovery.resolver.ClasspathRootResolver;
import org.antublue.test.engine.internal.discovery.resolver.MethodSelectorResolver;
import org.antublue.test.engine.internal.discovery.resolver.PackageSelectorResolver;
import org.antublue.test.engine.internal.discovery.resolver.UniqueIdSelectorResolver;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.predicate.TestClassPredicate;
import org.antublue.test.engine.internal.predicate.TestClassTagPredicate;
import org.antublue.test.engine.internal.predicate.TestMethodPredicate;
import org.antublue.test.engine.internal.predicate.TestMethodTagPredicate;
import org.antublue.test.engine.internal.util.Cast;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class TestEngineDiscoveryRequestResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngineDiscoveryRequestResolver.class);
    private final ClasspathRootResolver classpathRootResolver = new ClasspathRootResolver();
    private final PackageSelectorResolver packageSelectorResolver = new PackageSelectorResolver();
    private final ClassSelectorResolver classSelectorResolver = new ClassSelectorResolver();
    private final MethodSelectorResolver methodSelectorResolver = new MethodSelectorResolver();
    private final UniqueIdSelectorResolver uniqueIdSelectorResolver = new UniqueIdSelectorResolver();
    private final TestClassPredicate includeTestClassPredicate = TestEngineConfiguration.getInstance().get("antublue.test.engine.test.class.include").map(value -> {
        LOGGER.trace("%s [%s]", "antublue.test.engine.test.class.include", value);
        return value;
    }).map(TestClassPredicate::of).orElse(null);
    private final TestClassPredicate excludeTestClassPredicate = TestEngineConfiguration.getInstance().get("antublue.test.engine.test.class.exclude").map(value -> {
        LOGGER.trace("%s [%s]", "antublue.test.engine.test.class.exclude", value);
        return value;
    }).map(TestClassPredicate::of).orElse(null);
    private final TestMethodPredicate includeTestMethodPredicate = TestEngineConfiguration.getInstance().get("antublue.test.engine.test.method.include").map(value -> {
        LOGGER.trace("%s [%s]", "antublue.test.engine.test.method.include", value);
        return value;
    }).map(TestMethodPredicate::of).orElse(null);
    private final TestMethodPredicate excludeTestMethodPredicate = TestEngineConfiguration.getInstance().get("antublue.test.engine.test.method.exclude").map(value -> {
        LOGGER.trace("%s [%s]", "antublue.test.engine.test.method.exclude", value);
        return value;
    }).map(TestMethodPredicate::of).orElse(null);
    private final TestClassTagPredicate includeTestClassTagPredicate = TestEngineConfiguration.getInstance().get("antublue.test.engine.test.class.tag.include").map(value -> {
        LOGGER.trace("%s [%s]", "antublue.test.engine.test.class.tag.include", value);
        return value;
    }).map(TestClassTagPredicate::of).orElse(null);
    private final TestClassTagPredicate excludeTestClassTagPredicate = TestEngineConfiguration.getInstance().get("antublue.test.engine.test.class.tag.exclude").map(value -> {
        LOGGER.trace("%s [%s]", "antublue.test.engine.test.class.tag.exclude", value);
        return value;
    }).map(TestClassTagPredicate::of).orElse(null);
    private final TestMethodTagPredicate includeTestMethodTagPredicate = TestEngineConfiguration.getInstance().get("antublue.test.engine.test.method.tag.include").map(value -> {
        LOGGER.trace("%s [%s]", "antublue.test.engine.test.method.tag.include", value);
        return value;
    }).map(TestMethodTagPredicate::of).orElse(null);
    private final TestMethodTagPredicate excludeTestMethodTagPredicate = TestEngineConfiguration.getInstance().get("antublue.test.engine.test.method.tag.exclude").map(value -> {
        LOGGER.trace("%s [%s]", "antublue.test.engine.test.method.tag.exclude", value);
        return value;
    }).map(TestMethodTagPredicate::of).orElse(null);

    public void resolve(EngineDiscoveryRequest engineDiscoveryRequest, EngineDescriptor engineDescriptor) {
        LOGGER.trace("resolve(EngineDiscoveryRequest, EngineDescriptor)");
        try {
            engineDiscoveryRequest.getSelectorsByType(ClasspathRootSelector.class).stream().sorted(Comparator.comparing(o -> o.getClasspathRoot())).collect(Collectors.toList()).forEach(classpathRootSelector -> this.classpathRootResolver.resolve((ClasspathRootSelector)classpathRootSelector, engineDescriptor));
            engineDiscoveryRequest.getSelectorsByType(PackageSelector.class).stream().sorted(Comparator.comparing(o -> o.getPackageName())).collect(Collectors.toList()).forEach(packageSelector -> this.packageSelectorResolver.resolve((PackageSelector)packageSelector, engineDescriptor));
            engineDiscoveryRequest.getSelectorsByType(ClassSelector.class).stream().sorted(Comparator.comparing(o -> o.getJavaClass().getName())).collect(Collectors.toList()).forEach(classSelector -> this.classSelectorResolver.resolve((ClassSelector)classSelector, engineDescriptor));
            engineDiscoveryRequest.getSelectorsByType(MethodSelector.class).stream().sorted(Comparator.comparing(o -> o.getJavaMethod().getName())).collect(Collectors.toList()).forEach(methodSelector -> this.methodSelectorResolver.resolve((MethodSelector)methodSelector, engineDescriptor));
            engineDiscoveryRequest.getSelectorsByType(UniqueIdSelector.class).stream().sorted(Comparator.comparing(o -> o.getUniqueId().toString())).collect(Collectors.toList()).forEach(uniqueIdSelector -> this.uniqueIdSelectorResolver.resolve((UniqueIdSelector)uniqueIdSelector, engineDescriptor));
            this.processPackageNameFilters(engineDiscoveryRequest, engineDescriptor);
            this.processTestClassPredicates(engineDescriptor);
            this.processTestMethodPredicates(engineDescriptor);
            this.processTestClassTagPredicates(engineDescriptor);
            this.processTestMethodTagPredicates(engineDescriptor);
        }
        catch (TestEngineException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new TestEngineException("Exception processing engine discovery request", e);
        }
        catch (Throwable t) {
            throw new TestEngineException("Exception processing engine discovery request", t);
        }
    }

    private void processPackageNameFilters(EngineDiscoveryRequest engineDiscoveryRequest, EngineDescriptor engineDescriptor) {
        LOGGER.trace("processPackageNameFilters");
        List packageNameFilters = engineDiscoveryRequest.getFiltersByType(PackageNameFilter.class);
        LOGGER.trace("packageNameFilters size [%d]", (Object)packageNameFilters.size());
        for (PackageNameFilter packageNameFilter : packageNameFilters) {
            LinkedHashSet testDescriptors = new LinkedHashSet(engineDescriptor.getChildren());
            for (TestDescriptor testDescriptor : testDescriptors) {
                ClassTestDescriptor classTestDescriptor = (ClassTestDescriptor)((Object)Cast.cast(testDescriptor));
                LinkedHashSet testDescriptors2 = new LinkedHashSet(classTestDescriptor.getChildren());
                for (TestDescriptor testDescriptor2 : testDescriptors2) {
                    ParameterTestDescriptor parameterTestDescriptor = (ParameterTestDescriptor)((Object)Cast.cast(testDescriptor2));
                    LinkedHashSet testDescriptors3 = new LinkedHashSet(testDescriptor2.getChildren());
                    for (TestDescriptor testDescriptor3 : testDescriptors3) {
                        MethodTestDescriptor methodTestDescriptor = (MethodTestDescriptor)((Object)Cast.cast(testDescriptor3));
                        Class<?> clazz = methodTestDescriptor.getTestClass();
                        String className = clazz.getName();
                        if (!packageNameFilter.apply((Object)className).excluded()) continue;
                        methodTestDescriptor.removeFromHierarchy();
                    }
                    Class<?> clazz = parameterTestDescriptor.getTestClass();
                    String className = clazz.getName();
                    if (!packageNameFilter.apply((Object)className).excluded()) continue;
                    parameterTestDescriptor.removeFromHierarchy();
                }
                Class<?> clazz = classTestDescriptor.getTestClass();
                String className = clazz.getName();
                if (!packageNameFilter.apply((Object)className).excluded()) continue;
                classTestDescriptor.removeFromHierarchy();
            }
        }
        engineDescriptor.prune();
    }

    private void processTestClassPredicates(EngineDescriptor engineDescriptor) {
        Class<?> clazz;
        UniqueId classTestDescriptorUniqueId;
        ClassTestDescriptor classTestDescriptor;
        LinkedHashSet children;
        LOGGER.trace("processTestClassPredicates");
        if (this.includeTestClassPredicate != null) {
            LOGGER.trace("includeTestClassPredicate [%s]", (Object)this.includeTestClassPredicate.getRegex());
            children = new LinkedHashSet(engineDescriptor.getChildren());
            for (TestDescriptor child : children) {
                if (!(child instanceof ClassTestDescriptor)) continue;
                classTestDescriptor = (ClassTestDescriptor)((Object)Cast.cast(child));
                classTestDescriptorUniqueId = classTestDescriptor.getUniqueId();
                clazz = classTestDescriptor.getTestClass();
                if (this.includeTestClassPredicate.test(clazz)) {
                    LOGGER.trace("  accept [%s]", (Object)classTestDescriptorUniqueId);
                    continue;
                }
                LOGGER.trace("  prune  [%s]", (Object)classTestDescriptorUniqueId);
                classTestDescriptor.removeFromHierarchy();
            }
        }
        if (this.excludeTestClassPredicate != null) {
            LOGGER.trace("excludeTestClassPredicate [%s]", (Object)this.excludeTestClassPredicate.getRegex());
            children = new LinkedHashSet(engineDescriptor.getChildren());
            for (TestDescriptor child : children) {
                if (!(child instanceof ClassTestDescriptor)) continue;
                classTestDescriptor = (ClassTestDescriptor)((Object)Cast.cast(child));
                classTestDescriptorUniqueId = classTestDescriptor.getUniqueId();
                clazz = classTestDescriptor.getTestClass();
                if (this.excludeTestClassPredicate.test(clazz)) {
                    LOGGER.trace("  prune  [%s]", (Object)classTestDescriptorUniqueId);
                    classTestDescriptor.removeFromHierarchy();
                    continue;
                }
                LOGGER.trace("  accept [%s]", (Object)classTestDescriptorUniqueId);
            }
        }
    }

    private void processTestMethodPredicates(EngineDescriptor engineDescriptor) {
        Method method;
        UniqueId methodTestDescriptorUniqueId;
        MethodTestDescriptor methodTestDescriptor;
        LinkedHashSet greatGrandChildren;
        Set grandChildren;
        Set children;
        LOGGER.trace("processTestMethodPredicates");
        if (this.includeTestMethodPredicate != null) {
            LOGGER.trace("includeTestMethodPredicate [%s]", (Object)this.includeTestMethodPredicate.getRegex());
            children = engineDescriptor.getChildren();
            for (TestDescriptor child : children) {
                if (!(child instanceof ClassTestDescriptor)) continue;
                grandChildren = child.getChildren();
                for (TestDescriptor grandChild : grandChildren) {
                    if (!(grandChild instanceof ParameterTestDescriptor)) continue;
                    greatGrandChildren = new LinkedHashSet(grandChild.getChildren());
                    for (TestDescriptor greatGrandChild : greatGrandChildren) {
                        if (!(greatGrandChild instanceof MethodTestDescriptor)) continue;
                        methodTestDescriptor = (MethodTestDescriptor)((Object)Cast.cast(greatGrandChild));
                        methodTestDescriptorUniqueId = methodTestDescriptor.getUniqueId();
                        method = methodTestDescriptor.getTestMethod();
                        if (this.includeTestMethodPredicate.test(method)) {
                            LOGGER.trace("  accept [%s]", (Object)methodTestDescriptorUniqueId);
                            continue;
                        }
                        LOGGER.trace("  prune  [%s]", (Object)methodTestDescriptorUniqueId);
                        methodTestDescriptor.removeFromHierarchy();
                    }
                }
            }
        }
        if (this.excludeTestMethodPredicate != null) {
            LOGGER.trace("excludeTestMethodPredicate [%s]", (Object)this.excludeTestMethodPredicate.getRegex());
            children = engineDescriptor.getChildren();
            for (TestDescriptor child : children) {
                if (!(child instanceof ClassTestDescriptor)) continue;
                grandChildren = child.getChildren();
                for (TestDescriptor grandChild : grandChildren) {
                    if (!(grandChild instanceof ParameterTestDescriptor)) continue;
                    greatGrandChildren = new LinkedHashSet(grandChild.getChildren());
                    for (TestDescriptor greatGrandChild : greatGrandChildren) {
                        if (!(greatGrandChild instanceof MethodTestDescriptor)) continue;
                        methodTestDescriptor = (MethodTestDescriptor)((Object)Cast.cast(greatGrandChild));
                        methodTestDescriptorUniqueId = methodTestDescriptor.getUniqueId();
                        method = methodTestDescriptor.getTestMethod();
                        if (this.excludeTestMethodPredicate.test(method)) {
                            LOGGER.trace("  prune  [%s]", (Object)methodTestDescriptorUniqueId);
                            methodTestDescriptor.removeFromHierarchy();
                            continue;
                        }
                        LOGGER.trace("  accept [%s]", (Object)methodTestDescriptorUniqueId);
                    }
                }
            }
        }
    }

    private void processTestClassTagPredicates(EngineDescriptor engineDescriptor) {
        Class<?> clazz;
        UniqueId classTestDescriptorUniqueId;
        ClassTestDescriptor testEngineClassTestDescriptor;
        LinkedHashSet children;
        LOGGER.trace("processTestClassTagPredicates");
        if (this.includeTestClassTagPredicate != null) {
            LOGGER.trace("includeTestClassTagPredicate [%s]", (Object)this.includeTestClassTagPredicate.getRegex());
            children = new LinkedHashSet(engineDescriptor.getChildren());
            for (TestDescriptor child : children) {
                if (!(child instanceof ClassTestDescriptor)) continue;
                testEngineClassTestDescriptor = (ClassTestDescriptor)((Object)Cast.cast(child));
                classTestDescriptorUniqueId = testEngineClassTestDescriptor.getUniqueId();
                clazz = testEngineClassTestDescriptor.getTestClass();
                if (this.includeTestClassTagPredicate.test(clazz)) {
                    LOGGER.trace("  accept [%s]", (Object)classTestDescriptorUniqueId);
                    continue;
                }
                LOGGER.trace("  prune  [%s]", (Object)classTestDescriptorUniqueId);
                testEngineClassTestDescriptor.removeFromHierarchy();
            }
        }
        if (this.excludeTestClassTagPredicate != null) {
            LOGGER.trace("excludeTestClassTagPredicate [%s]", (Object)this.excludeTestClassTagPredicate.getRegex());
            children = new LinkedHashSet(engineDescriptor.getChildren());
            for (TestDescriptor child : children) {
                if (!(child instanceof ClassTestDescriptor)) continue;
                testEngineClassTestDescriptor = (ClassTestDescriptor)((Object)Cast.cast(child));
                classTestDescriptorUniqueId = testEngineClassTestDescriptor.getUniqueId();
                clazz = testEngineClassTestDescriptor.getTestClass();
                if (this.excludeTestClassTagPredicate.test(clazz)) {
                    LOGGER.trace("  prune  [%s]", (Object)classTestDescriptorUniqueId);
                    testEngineClassTestDescriptor.removeFromHierarchy();
                    continue;
                }
                LOGGER.trace("  accept [%s]", (Object)classTestDescriptorUniqueId);
            }
        }
    }

    private void processTestMethodTagPredicates(EngineDescriptor engineDescriptor) {
        Method method;
        UniqueId methodTestDescriptorUniqueId;
        MethodTestDescriptor methodTestDescriptor;
        LinkedHashSet greatGrandChildren;
        Set grandChildren;
        Set children;
        LOGGER.trace("processTestMethodTagPredicates");
        if (this.includeTestMethodTagPredicate != null) {
            LOGGER.trace("includeTestMethodTagPredicate [%s]", (Object)this.includeTestMethodTagPredicate.getRegex());
            children = engineDescriptor.getChildren();
            for (TestDescriptor child : children) {
                if (!(child instanceof ClassTestDescriptor)) continue;
                grandChildren = child.getChildren();
                for (TestDescriptor grandChild : grandChildren) {
                    if (!(grandChild instanceof ParameterTestDescriptor)) continue;
                    greatGrandChildren = new LinkedHashSet(grandChild.getChildren());
                    for (TestDescriptor greatGrandChild : greatGrandChildren) {
                        if (!(greatGrandChild instanceof MethodTestDescriptor)) continue;
                        methodTestDescriptor = (MethodTestDescriptor)((Object)Cast.cast(greatGrandChild));
                        methodTestDescriptorUniqueId = methodTestDescriptor.getUniqueId();
                        method = methodTestDescriptor.getTestMethod();
                        if (this.includeTestMethodTagPredicate.test(method)) {
                            LOGGER.trace("  accept [%s]", (Object)methodTestDescriptorUniqueId);
                            continue;
                        }
                        LOGGER.trace("  prune  [%s]", (Object)methodTestDescriptorUniqueId);
                        methodTestDescriptor.removeFromHierarchy();
                    }
                }
            }
        }
        if (this.excludeTestMethodTagPredicate != null) {
            LOGGER.trace("excludeTestMethodTagPredicate [%s]", (Object)this.excludeTestMethodTagPredicate.getRegex());
            children = engineDescriptor.getChildren();
            for (TestDescriptor child : children) {
                if (!(child instanceof ClassTestDescriptor)) continue;
                grandChildren = child.getChildren();
                for (TestDescriptor grandChild : grandChildren) {
                    if (!(grandChild instanceof ParameterTestDescriptor)) continue;
                    greatGrandChildren = new LinkedHashSet(grandChild.getChildren());
                    for (TestDescriptor greatGrandChild : greatGrandChildren) {
                        if (!(greatGrandChild instanceof MethodTestDescriptor)) continue;
                        methodTestDescriptor = (MethodTestDescriptor)((Object)Cast.cast(greatGrandChild));
                        methodTestDescriptorUniqueId = methodTestDescriptor.getUniqueId();
                        method = methodTestDescriptor.getTestMethod();
                        if (this.excludeTestMethodTagPredicate.test(method)) {
                            LOGGER.trace("  prune  [%s]", (Object)methodTestDescriptorUniqueId);
                            methodTestDescriptor.removeFromHierarchy();
                            continue;
                        }
                        LOGGER.trace("  accept [%s]", (Object)methodTestDescriptorUniqueId);
                    }
                }
            }
        }
    }
}

