/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.Optional;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.TestExecutionContext;
import org.antublue.test.engine.internal.descriptor.ExtendedAbstractTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

public final class ParameterTestDescriptor
extends ExtendedAbstractTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterTestDescriptor.class);
    private final Class<?> testClass;
    private final Parameter testParameter;

    public ParameterTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Parameter testParameter) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testParameter = testParameter;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)TestEngineReflectionUtils.getParameterSupplierMethod(this.testClass)));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public boolean isTest() {
        return false;
    }

    public boolean isContainer() {
        return true;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Parameter getTestParameter() {
        return this.testParameter;
    }

    @Override
    public void execute(TestExecutionContext testExecutionContext) {
        ThrowableCollector throwableCollector = this.getThrowableCollector();
        EngineExecutionListener engineExecutionListener = testExecutionContext.getExecutionRequest().getEngineExecutionListener();
        engineExecutionListener.executionStarted((TestDescriptor)this);
        Object testInstance = testExecutionContext.getTestInstance();
        Class<?> testClass = testInstance.getClass();
        String testClassName = testClass.getName();
        try {
            testExecutionContext.setTestInstance(testInstance);
            LOGGER.trace("injecting [%s] @TestEngine.Parameter fields ...", (Object)testClassName);
            TestEngineReflectionUtils.getParameterFields(testClass).forEach(field -> {
                LOGGER.trace("injecting [%s] @TestEngine.Parameter field [%s] ...", testClassName, field.getName());
                try {
                    field.set(testInstance, this.testParameter);
                }
                finally {
                    this.flush();
                }
            });
            LOGGER.trace("invoking [%s] @TestEngine.Parameter methods ...", (Object)testClassName);
            TestEngineReflectionUtils.getParameterMethods(testClass).forEach(method -> {
                LOGGER.trace("invoking [%s] @TestEngine.Parameter method [%s] ...", testClassName, method.getName());
                try {
                    method.invoke(testInstance, this.testParameter);
                }
                finally {
                    this.flush();
                }
            });
        }
        catch (Throwable t) {
            throwableCollector.add(t);
            ParameterTestDescriptor.resolve(t).printStackTrace();
        }
        if (throwableCollector.isEmpty()) {
            try {
                TestEngineReflectionUtils.getBeforeAllMethods(testClass).forEach(method -> {
                    LOGGER.trace("invoking [%s] @TestEngine.BeforeAll method [%s] ...", testClassName, method.getName());
                    try {
                        method.invoke(testInstance, (Object[])null);
                    }
                    finally {
                        this.flush();
                    }
                });
            }
            catch (Throwable t) {
                throwableCollector.add(t);
                ParameterTestDescriptor.resolve(t).printStackTrace();
            }
            if (!throwableCollector.isEmpty()) {
                this.getChildren(MethodTestDescriptor.class).forEach(methodTestDescriptor -> methodTestDescriptor.skip(testExecutionContext));
            }
        } else {
            this.getChildren(MethodTestDescriptor.class).forEach(methodTestDescriptor -> methodTestDescriptor.skip(testExecutionContext));
        }
        if (throwableCollector.isEmpty()) {
            this.getChildren(MethodTestDescriptor.class).forEach(methodTestDescriptor -> {
                methodTestDescriptor.execute(testExecutionContext);
                throwableCollector.addAll(methodTestDescriptor.getThrowableCollector());
            });
        }
        try {
            TestEngineReflectionUtils.getAfterAllMethods(testClass).forEach(method -> {
                LOGGER.trace("invoking [%s] @TestEngine.AfterAll method [%s] ...", testClassName, method.getName());
                try {
                    method.invoke(testInstance, (Object[])null);
                }
                finally {
                    this.flush();
                }
            });
        }
        catch (Throwable t) {
            throwableCollector.add(t);
            ParameterTestDescriptor.resolve(t).printStackTrace();
        }
        if (throwableCollector.isEmpty()) {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)throwableCollector.getFirst().orElse(null)));
        }
    }
}

