/*
 * Copyright 2022-2023 Douglas Hoard
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.antublue.test.engine.internal.util;

import java.util.function.Consumer;

@FunctionalInterface
public interface ThrowableConsumer<T> extends Consumer<T> {

    @Override
    default void accept(T t) {
        try {
            acceptThrowable(t);
        } catch(Throwable tt) {
            if (tt instanceof RuntimeException) {
                throw (RuntimeException) tt;
            } else {
                throw new ThrowableConsumerException(tt);
            }
        }
    }

    /**
     * Method to accept a value that may throw a Throwable
     * @param t t
     * @throws Throwable Throwable
     */
    void acceptThrowable(T t) throws Throwable;
}
