/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery.resolver;

import java.util.concurrent.atomic.AtomicInteger;
import org.antublue.test.engine.internal.TestDescriptorUtils;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ParameterTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class ClassSelectorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassSelectorResolver.class);

    public void resolve(ClassSelector classSelector, EngineDescriptor engineDescriptor) {
        LOGGER.trace("resolve [%s]", (Object)classSelector.getClassName());
        UniqueId engineDescriptorUniqueId = engineDescriptor.getUniqueId();
        Class clazz = classSelector.getJavaClass();
        LOGGER.trace("  class [%s]", (Object)clazz.getName());
        UniqueId classTestDescriptorUniqueId = engineDescriptorUniqueId.append("class", clazz.getName());
        ClassTestDescriptor testEngineClassTestDescriptor = TestDescriptorUtils.createClassTestDescriptor(classTestDescriptorUniqueId, clazz);
        engineDescriptor.addChild((TestDescriptor)testEngineClassTestDescriptor);
        AtomicInteger index = new AtomicInteger();
        TestEngineReflectionUtils.getParameters(clazz).forEach(parameter -> {
            UniqueId parameterTestDescriptorUniqueId = classTestDescriptorUniqueId.append("parameter", String.valueOf(index.getAndIncrement()));
            ParameterTestDescriptor parameterTestDescriptor = TestDescriptorUtils.createParameterTestDescriptor(parameterTestDescriptorUniqueId, clazz, parameter);
            testEngineClassTestDescriptor.addChild((TestDescriptor)parameterTestDescriptor);
            TestEngineReflectionUtils.getTestMethods(clazz).forEach(method -> {
                UniqueId methodTestDescriptorUniqueId = parameterTestDescriptorUniqueId.append("method", method.getName());
                MethodTestDescriptor methodTestDescriptor = TestDescriptorUtils.createMethodTestDescriptor(methodTestDescriptorUniqueId, clazz, parameter, method);
                parameterTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
            });
            parameterTestDescriptor.prune();
        });
    }
}

