/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery.resolver;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.TestDescriptorUtils;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ParameterTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class MethodSelectorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodSelectorResolver.class);
    private static final Predicate<Class<?>> IS_TEST_CLASS = clazz -> {
        if (clazz.isAnnotationPresent(TestEngine.BaseClass.class) || clazz.isAnnotationPresent(TestEngine.Disabled.class)) {
            return false;
        }
        int modifiers = clazz.getModifiers();
        return !Modifier.isAbstract(modifiers) && !TestEngineReflectionUtils.getTestMethods(clazz).isEmpty();
    };

    public void resolve(MethodSelector methodSelector, EngineDescriptor engineDescriptor) {
        LOGGER.trace("resolve [%s]", (Object)methodSelector.getJavaMethod().getName());
        UniqueId engineDescriptorUniqueId = engineDescriptor.getUniqueId();
        Class clazz = methodSelector.getJavaClass();
        Method method = methodSelector.getJavaMethod();
        UniqueId classTestDescriptorUniqueId = engineDescriptorUniqueId.append("class", clazz.getName());
        ClassTestDescriptor classTestDescriptor = TestDescriptorUtils.createClassTestDescriptor(classTestDescriptorUniqueId, clazz);
        AtomicInteger index = new AtomicInteger();
        TestEngineReflectionUtils.getParameters(clazz).forEach(parameter -> {
            UniqueId parameterTestDescriptorUniqueId = classTestDescriptorUniqueId.append("parameter", String.valueOf(index.getAndIncrement()));
            ParameterTestDescriptor parameterTestDescriptor = TestDescriptorUtils.createParameterTestDescriptor(parameterTestDescriptorUniqueId, clazz, parameter);
            UniqueId methodTestDescriptorUniqueId = parameterTestDescriptorUniqueId.append("method", method.getName());
            MethodTestDescriptor methodTestDescriptor = TestDescriptorUtils.createMethodTestDescriptor(methodTestDescriptorUniqueId, clazz, parameter, method);
            parameterTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
            classTestDescriptor.addChild((TestDescriptor)parameterTestDescriptor);
            engineDescriptor.addChild((TestDescriptor)classTestDescriptor);
        });
    }
}

