/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.reflect.Method;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.internal.TestClassConfigurationException;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ParameterTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.Switch;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public final class TestDescriptorUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestDescriptorUtils.class);

    private TestDescriptorUtils() {
    }

    public static ClassTestDescriptor createClassTestDescriptor(UniqueId uniqueId, Class<?> clazz) {
        return new ClassTestDescriptor(uniqueId, TestEngineReflectionUtils.getDisplayName(clazz), clazz);
    }

    public static ParameterTestDescriptor createParameterTestDescriptor(UniqueId uniqueId, Class<?> clazz, Parameter parameter) {
        if (TestEngineReflectionUtils.getParameterSupplierMethod(clazz) == null) {
            throw new TestClassConfigurationException(String.format("Test class [%s] must declare an @TestEngine.ParameterSupplier method", clazz.getName()));
        }
        if (TestEngineReflectionUtils.getParameterFields(clazz).isEmpty() && TestEngineReflectionUtils.getParameterMethods(clazz).isEmpty()) {
            throw new TestClassConfigurationException(String.format("Test class [%s] must declare a @TestEngine.Parameter field or method", clazz.getName()));
        }
        return new ParameterTestDescriptor(uniqueId, parameter.name(), clazz, parameter);
    }

    public static MethodTestDescriptor createMethodTestDescriptor(UniqueId uniqueId, Class<?> clazz, Parameter parameter, Method method) {
        return new MethodTestDescriptor(uniqueId, TestEngineReflectionUtils.getDisplayName(method), clazz, parameter, method);
    }

    public static void trace(TestDescriptor testDescriptor) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("--------------------");
            LOGGER.trace("Test descriptor tree");
            LOGGER.trace("--------------------");
            TestDescriptorUtils.trace(testDescriptor, 0);
            LOGGER.trace("------------------------");
        }
    }

    private static void trace(TestDescriptor testDescriptor, int indent) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            stringBuilder.append(" ");
        }
        Switch.switchType(testDescriptor, Switch.switchCase(MethodTestDescriptor.class, testMethodTestDescriptor -> stringBuilder.append("method -> ").append(testMethodTestDescriptor.getUniqueId()).append("()")), Switch.switchCase(ParameterTestDescriptor.class, testEngineParameterTestDescriptor -> stringBuilder.append("parameter -> ").append(testEngineParameterTestDescriptor.getUniqueId())), Switch.switchCase(ClassTestDescriptor.class, testClassTestDescriptor -> stringBuilder.append("class -> ").append(testClassTestDescriptor.getUniqueId())), Switch.switchCase(EngineDescriptor.class, engineDescriptor -> stringBuilder.append("engine -> ").append(engineDescriptor.getDisplayName())));
        LOGGER.trace(stringBuilder.toString());
        testDescriptor.getChildren().forEach(t -> TestDescriptorUtils.trace(t, indent + 2));
    }
}

