/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.logger;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.antublue.test.engine.internal.logger.Level;

public class Logger {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd | HH:mm:ss.SSS", Locale.getDefault());
    private static final int OFF = 0;
    private static final int ERROR = 100;
    private static final int WARNING = 200;
    private static final int INFO = 300;
    private static final int DEBUG = 400;
    private static final int TRACE = 500;
    private static final int ALL = Integer.MAX_VALUE;
    private static final Map<String, Integer> LOG_LEVEL_MAP = new HashMap<String, Integer>();
    private final String name;
    private final AtomicReference<Level> level;

    public Logger(String name, Level level) {
        this.name = name;
        this.level = new AtomicReference<Level>(level);
    }

    public boolean isTraceEnabled() {
        return this.level.get().toInt() >= Level.TRACE.toInt();
    }

    public boolean isDebugEnabled() {
        return this.level.get().toInt() >= Level.DEBUG.toInt();
    }

    public boolean isInfoEnabled() {
        return this.level.get().toInt() >= Level.INFO.toInt();
    }

    public boolean isWarnEnabled() {
        return this.level.get().toInt() >= Level.WARN.toInt();
    }

    public boolean isErrorEnabled() {
        return this.level.get().toInt() >= Level.ERROR.toInt();
    }

    public void trace(String message) {
        if (this.isTraceEnabled()) {
            this.log(System.out, this.createMessage(Level.TRACE, message));
        }
    }

    public void trace(String format, Object object) {
        if (this.isTraceEnabled()) {
            this.trace(format, new Object[]{object});
        }
    }

    public void trace(String format, Object ... objects) {
        if (this.isTraceEnabled()) {
            Objects.requireNonNull(format);
            this.log(System.out, this.createMessage(Level.TRACE, String.format(format, objects)));
        }
    }

    public void trace(String message, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.log(System.out, this.createMessage(Level.TRACE, this.createMessage(message, throwable)));
        }
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.log(System.out, this.createMessage(Level.DEBUG, message));
        }
    }

    public void debug(String format, Object object) {
        if (this.isDebugEnabled()) {
            this.debug(format, new Object[]{object});
        }
    }

    public void debug(String format, Object ... objects) {
        if (this.isDebugEnabled()) {
            Objects.requireNonNull(format);
            this.log(System.out, this.createMessage(Level.DEBUG, String.format(format, objects)));
        }
    }

    public void debug(String message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.log(System.out, this.createMessage(Level.DEBUG, this.createMessage(message, throwable)));
        }
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.log(System.out, this.createMessage(Level.INFO, message));
        }
    }

    public void info(String format, Object object) {
        if (this.isInfoEnabled()) {
            this.info(format, new Object[]{object});
        }
    }

    public void info(String format, Object ... objects) {
        if (this.isInfoEnabled()) {
            Objects.requireNonNull(format);
            this.log(System.out, this.createMessage(Level.INFO, String.format(format, objects)));
        }
    }

    public void info(String message, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.log(System.out, this.createMessage(Level.INFO, this.createMessage(message, throwable)));
        }
    }

    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.log(System.out, this.createMessage(Level.WARN, message));
        }
    }

    public void warn(String format, Object object) {
        if (this.isWarnEnabled()) {
            this.warn(format, new Object[]{object});
        }
    }

    public void warn(String format, Object ... objects) {
        if (this.isWarnEnabled()) {
            Objects.requireNonNull(format);
            this.log(System.out, this.createMessage(Level.WARN, String.format(format, objects)));
        }
    }

    public void warn(String message, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.log(System.out, this.createMessage(Level.WARN, this.createMessage(message, throwable)));
        }
    }

    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.log(System.err, this.createMessage(Level.ERROR, message));
        }
    }

    public void error(String format, Object object) {
        if (this.isErrorEnabled()) {
            this.error(format, new Object[]{object});
        }
    }

    public void error(String format, Object ... objects) {
        if (this.isErrorEnabled()) {
            Objects.requireNonNull(format);
            this.log(System.out, this.createMessage(Level.ERROR, String.format(format, objects)));
        }
    }

    public void error(String message, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.log(System.out, this.createMessage(Level.ERROR, this.createMessage(message, throwable)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createMessage(Level level, String message) {
        String dateTime;
        SimpleDateFormat simpleDateFormat = SIMPLE_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            dateTime = SIMPLE_DATE_FORMAT.format(new Date());
        }
        return String.format("%s | %s | %s | %s | %s ", dateTime, Thread.currentThread().getName(), level.toString(), this.name, message);
    }

    private String createMessage(String message, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            printWriter.println(message);
            if (throwable != null) {
                throwable.printStackTrace(printWriter);
            }
        }
        return stringWriter.toString();
    }

    private void log(PrintStream printStream, String message) {
        printStream.println(message);
        printStream.flush();
    }

    static {
        LOG_LEVEL_MAP.put("OFF", 0);
        LOG_LEVEL_MAP.put("ERROR", 100);
        LOG_LEVEL_MAP.put("WARNING", 200);
        LOG_LEVEL_MAP.put("INFO", 300);
        LOG_LEVEL_MAP.put("DEBUG", 400);
        LOG_LEVEL_MAP.put("TRACE", 500);
        LOG_LEVEL_MAP.put("ALL", Integer.MAX_VALUE);
    }
}

