/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery.resolver;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.internal.TestDescriptorUtils;
import org.antublue.test.engine.internal.TestEngineException;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ParameterTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.Cast;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class UniqueIdSelectorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(UniqueIdSelectorResolver.class);

    public void resolve(UniqueIdSelector uniqueIdSelector, EngineDescriptor engineDescriptor) {
        LOGGER.trace("resolve [%s]", (Object)uniqueIdSelector.getUniqueId());
        String className = null;
        try {
            UniqueId selectorUniqueId = uniqueIdSelector.getUniqueId();
            LOGGER.trace("selectorUniqueId [%s]", (Object)selectorUniqueId);
            UniqueId.Segment segment = selectorUniqueId.getLastSegment();
            if ("parameter".equals(segment.getType())) {
                LOGGER.trace("parameter [%s] selected", (Object)segment.getValue());
                UniqueId classTestDescriptorUniqueId = selectorUniqueId.removeLastSegment();
                UniqueId.Segment classSegment = classTestDescriptorUniqueId.getLastSegment();
                className = classSegment.getValue();
                LOGGER.trace("className [%s]", (Object)className);
                Class<?> clazz = Class.forName(className);
                ClassTestDescriptor classTestDescriptor = engineDescriptor.findByUniqueId(classTestDescriptorUniqueId).map(Cast::cast).orElseGet(() -> TestDescriptorUtils.createClassTestDescriptor(classTestDescriptorUniqueId, clazz));
                List<Parameter> parameters = TestEngineReflectionUtils.getParameters(clazz);
                Parameter parameter2 = parameters.get(Integer.parseInt(segment.getValue()));
                ParameterTestDescriptor parameterTestDescriptor = classTestDescriptor.findByUniqueId(selectorUniqueId).map(Cast::cast).orElseGet(() -> TestDescriptorUtils.createParameterTestDescriptor(selectorUniqueId, clazz, parameter2));
                TestEngineReflectionUtils.getTestMethods(clazz).forEach(method -> {
                    UniqueId methodTestDescriptorUniqueId = selectorUniqueId.append("method", method.getName());
                    MethodTestDescriptor methodTestDescriptor = TestDescriptorUtils.createMethodTestDescriptor(methodTestDescriptorUniqueId, clazz, parameter2, method);
                    parameterTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
                });
                classTestDescriptor.addChild((TestDescriptor)parameterTestDescriptor);
                engineDescriptor.addChild((TestDescriptor)classTestDescriptor);
            } else if ("class".equals(segment.getType())) {
                className = segment.getValue();
                LOGGER.trace("className [%s]", (Object)className);
                Class<?> clazz = Class.forName(className);
                ClassTestDescriptor classTestDescriptor = engineDescriptor.findByUniqueId(selectorUniqueId).map(Cast::cast).orElseGet(() -> TestDescriptorUtils.createClassTestDescriptor(selectorUniqueId, clazz));
                AtomicInteger index = new AtomicInteger();
                TestEngineReflectionUtils.getParameters(clazz).forEach(parameter -> {
                    UniqueId parameterTestDescriptorUniqueId = selectorUniqueId.append("parameter", String.valueOf(index.getAndIncrement()));
                    ParameterTestDescriptor parameterTestDescriptor = TestDescriptorUtils.createParameterTestDescriptor(parameterTestDescriptorUniqueId, clazz, parameter);
                    TestEngineReflectionUtils.getTestMethods(clazz).forEach(method -> {
                        UniqueId methodUniqueId = parameterTestDescriptorUniqueId.append("method", method.getName());
                        MethodTestDescriptor methodTestDescriptor = TestDescriptorUtils.createMethodTestDescriptor(methodUniqueId, clazz, parameter, method);
                        parameterTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
                    });
                    classTestDescriptor.addChild((TestDescriptor)parameterTestDescriptor);
                });
                engineDescriptor.addChild((TestDescriptor)classTestDescriptor);
            }
        }
        catch (ClassNotFoundException e) {
            throw new TestEngineException(String.format("Class [%s] not found", className), e);
        }
    }
}

