/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery.resolver;

import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.TestDescriptorUtils;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class ClasspathRootResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathRootResolver.class);
    private static final Predicate<Class<?>> IS_TEST_CLASS = clazz -> {
        if (clazz.isAnnotationPresent(TestEngine.BaseClass.class) || clazz.isAnnotationPresent(TestEngine.Disabled.class)) {
            return false;
        }
        return !Modifier.isAbstract(clazz.getModifiers()) && !TestEngineReflectionUtils.getTestMethods(clazz).isEmpty();
    };

    public void resolve(ClasspathRootSelector classpathRootSelector, EngineDescriptor engineDescriptor) {
        LOGGER.trace("resolve [%s]", (Object)classpathRootSelector);
        UniqueId engineDescriptorUniqueId = engineDescriptor.getUniqueId();
        URI uri = classpathRootSelector.getClasspathRoot();
        LOGGER.trace("uri [%s]", (Object)uri);
        new ArrayList(ReflectionUtils.findAllClassesInClasspathRoot((URI)uri, IS_TEST_CLASS, name -> true)).stream().sorted(Comparator.comparing(TestEngineReflectionUtils::getDisplayName)).forEach(clazz -> {
            LOGGER.trace("  class [%s]", (Object)clazz.getName());
            UniqueId classTestDescriptorUniqueId = engineDescriptorUniqueId.append("class", clazz.getName());
            ClassTestDescriptor classTestDescriptor = TestDescriptorUtils.createClassTestDescriptor(classTestDescriptorUniqueId, clazz);
            engineDescriptor.addChild((TestDescriptor)classTestDescriptor);
            AtomicInteger index = new AtomicInteger();
            TestEngineReflectionUtils.getArguments(clazz).forEach(argument -> {
                UniqueId argumentTestDescriptorUniqueId = classTestDescriptorUniqueId.append("argument", String.valueOf(index.getAndIncrement()));
                ArgumentTestDescriptor argumentTestDescriptor = TestDescriptorUtils.createArgumentTestDescriptor(argumentTestDescriptorUniqueId, clazz, argument);
                classTestDescriptor.addChild((TestDescriptor)argumentTestDescriptor);
                TestEngineReflectionUtils.getTestMethods(clazz).forEach(method -> {
                    UniqueId methodTestDescriptorUniqueId = argumentTestDescriptorUniqueId.append("method", method.getName());
                    MethodTestDescriptor methodTestDescriptor = TestDescriptorUtils.createMethodTestDescriptor(methodTestDescriptorUniqueId, clazz, argument, method);
                    argumentTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
                });
                argumentTestDescriptor.prune();
            });
            classTestDescriptor.prune();
        });
    }
}

