/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery.resolver;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.TestDescriptorUtils;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class PackageSelectorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PackageSelectorResolver.class);
    private static final Predicate<Class<?>> IS_TEST_CLASS = clazz -> {
        if (clazz.isAnnotationPresent(TestEngine.BaseClass.class) || clazz.isAnnotationPresent(TestEngine.Disabled.class)) {
            return false;
        }
        int modifiers = clazz.getModifiers();
        return !Modifier.isAbstract(modifiers) && !TestEngineReflectionUtils.getTestMethods(clazz).isEmpty();
    };

    public void resolve(PackageSelector packageSelector, EngineDescriptor engineDescriptor) {
        LOGGER.trace("resolve [%s]", (Object)packageSelector.getPackageName());
        UniqueId engineDescriptorUniqueId = engineDescriptor.getUniqueId();
        String packageName = packageSelector.getPackageName();
        new ArrayList(ReflectionSupport.findAllClassesInPackage((String)packageName, IS_TEST_CLASS, name -> true)).stream().sorted(Comparator.comparing(Class::getName)).forEach(clazz -> {
            LOGGER.trace("  class [%s]", (Object)clazz.getName());
            UniqueId classTestDescriptorUniqueId = engineDescriptorUniqueId.append("class", clazz.getName());
            ClassTestDescriptor testEngineClassTestDescriptor = TestDescriptorUtils.createClassTestDescriptor(classTestDescriptorUniqueId, clazz);
            engineDescriptor.addChild((TestDescriptor)testEngineClassTestDescriptor);
            AtomicInteger index = new AtomicInteger();
            TestEngineReflectionUtils.getArguments(clazz).forEach(argument -> {
                UniqueId argumentTestDescriptorUniqueId = classTestDescriptorUniqueId.append("argument", String.valueOf(index.getAndIncrement()));
                ArgumentTestDescriptor testEngineArgumentTestDescriptor = TestDescriptorUtils.createArgumentTestDescriptor(argumentTestDescriptorUniqueId, clazz, argument);
                testEngineClassTestDescriptor.addChild((TestDescriptor)testEngineArgumentTestDescriptor);
                TestEngineReflectionUtils.getTestMethods(clazz).forEach(method -> {
                    UniqueId methodTestDescriptorUniqueId = argumentTestDescriptorUniqueId.append("method", method.getName());
                    MethodTestDescriptor methodTestDescriptor = TestDescriptorUtils.createMethodTestDescriptor(methodTestDescriptorUniqueId, clazz, argument, method);
                    testEngineArgumentTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
                });
                testEngineClassTestDescriptor.addChild((TestDescriptor)testEngineArgumentTestDescriptor);
                testEngineArgumentTestDescriptor.prune();
            });
            testEngineClassTestDescriptor.prune();
        });
    }
}

