/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery.resolver;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.TestDescriptorUtils;
import org.antublue.test.engine.internal.TestEngineException;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.Cast;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class UniqueIdSelectorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(UniqueIdSelectorResolver.class);

    public void resolve(UniqueIdSelector uniqueIdSelector, EngineDescriptor engineDescriptor) {
        LOGGER.trace("resolve [%s]", (Object)uniqueIdSelector.getUniqueId());
        String className = null;
        try {
            UniqueId selectorUniqueId = uniqueIdSelector.getUniqueId();
            LOGGER.trace("selectorUniqueId [%s]", (Object)selectorUniqueId);
            UniqueId.Segment segment = selectorUniqueId.getLastSegment();
            if ("argument".equals(segment.getType())) {
                LOGGER.trace("argument [%s] selected", (Object)segment.getValue());
                UniqueId classTestDescriptorUniqueId = selectorUniqueId.removeLastSegment();
                UniqueId.Segment classSegment = classTestDescriptorUniqueId.getLastSegment();
                className = classSegment.getValue();
                LOGGER.trace("className [%s]", (Object)className);
                Class<?> clazz = Class.forName(className);
                ClassTestDescriptor classTestDescriptor = engineDescriptor.findByUniqueId(classTestDescriptorUniqueId).map(Cast::cast).orElseGet(() -> TestDescriptorUtils.createClassTestDescriptor(classTestDescriptorUniqueId, clazz));
                List<Argument> arguments = TestEngineReflectionUtils.getArguments(clazz);
                Argument argument2 = arguments.get(Integer.parseInt(segment.getValue()));
                ArgumentTestDescriptor argumentTestDescriptor = classTestDescriptor.findByUniqueId(selectorUniqueId).map(Cast::cast).orElseGet(() -> TestDescriptorUtils.createArgumentTestDescriptor(selectorUniqueId, clazz, argument2));
                TestEngineReflectionUtils.getTestMethods(clazz).forEach(method -> {
                    UniqueId methodTestDescriptorUniqueId = selectorUniqueId.append("method", method.getName());
                    MethodTestDescriptor methodTestDescriptor = TestDescriptorUtils.createMethodTestDescriptor(methodTestDescriptorUniqueId, clazz, argument2, method);
                    argumentTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
                });
                classTestDescriptor.addChild((TestDescriptor)argumentTestDescriptor);
                engineDescriptor.addChild((TestDescriptor)classTestDescriptor);
            } else if ("class".equals(segment.getType())) {
                className = segment.getValue();
                LOGGER.trace("className [%s]", (Object)className);
                Class<?> clazz = Class.forName(className);
                ClassTestDescriptor classTestDescriptor = engineDescriptor.findByUniqueId(selectorUniqueId).map(Cast::cast).orElseGet(() -> TestDescriptorUtils.createClassTestDescriptor(selectorUniqueId, clazz));
                AtomicInteger index = new AtomicInteger();
                TestEngineReflectionUtils.getArguments(clazz).forEach(argument -> {
                    UniqueId argumentTestDescriptorUniqueId = selectorUniqueId.append("argument", String.valueOf(index.getAndIncrement()));
                    ArgumentTestDescriptor argumentTestDescriptor = TestDescriptorUtils.createArgumentTestDescriptor(argumentTestDescriptorUniqueId, clazz, argument);
                    TestEngineReflectionUtils.getTestMethods(clazz).forEach(method -> {
                        UniqueId methodUniqueId = argumentTestDescriptorUniqueId.append("method", method.getName());
                        MethodTestDescriptor methodTestDescriptor = TestDescriptorUtils.createMethodTestDescriptor(methodUniqueId, clazz, argument, method);
                        argumentTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
                    });
                    classTestDescriptor.addChild((TestDescriptor)argumentTestDescriptor);
                });
                engineDescriptor.addChild((TestDescriptor)classTestDescriptor);
            }
        }
        catch (ClassNotFoundException e) {
            throw new TestEngineException(String.format("Class [%s] not found", className), e);
        }
    }
}

