/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.antublue.test.engine.internal.TestEngineExecutionContext;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.antublue.test.engine.internal.util.ThrowableConsumerException;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;

abstract class ExtendedAbstractTestDescriptor
extends AbstractTestDescriptor {
    private final ThrowableCollector throwableCollector = new ThrowableCollector();

    protected ExtendedAbstractTestDescriptor(UniqueId uniqueId, String displayName) {
        super(uniqueId, displayName);
    }

    public <T> List<T> getChildren(Class<T> clazz) {
        return this.getChildren().stream().map(testDescriptor -> testDescriptor).collect(Collectors.toList());
    }

    protected ThrowableCollector getThrowableCollector() {
        return this.throwableCollector;
    }

    protected Throwable pruneStackTrace(Throwable throwable, String markerClassName) {
        if (throwable instanceof InvocationTargetException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof ThrowableConsumerException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof InvocationTargetException) {
            throwable = throwable.getCause();
        }
        ArrayList<StackTraceElement> workingStackTrace = new ArrayList<StackTraceElement>();
        List<StackTraceElement> stackTraceElements = Arrays.asList(throwable.getStackTrace());
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            String stackTraceClassName = stackTraceElement.getClassName();
            workingStackTrace.add(stackTraceElement);
            if (!stackTraceClassName.equals(markerClassName)) continue;
            break;
        }
        throwable.setStackTrace(workingStackTrace.toArray(new StackTraceElement[0]));
        return throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            PrintStream printStream2 = System.err;
            synchronized (printStream2) {
                System.out.flush();
                System.err.flush();
            }
        }
    }

    public abstract void execute(TestEngineExecutionContext var1);

    public void skip(TestEngineExecutionContext testEngineExecutionContext) {
        this.getChildren(ExtendedAbstractTestDescriptor.class).forEach(testDescriptor -> testDescriptor.skip(testEngineExecutionContext));
        testEngineExecutionContext.getExecutionRequest().getEngineExecutionListener().executionSkipped((TestDescriptor)this, "Skipped");
    }
}

