/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.Optional;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.TestEngineExecutionContext;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ExtendedAbstractTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

public final class MethodTestDescriptor
extends ExtendedAbstractTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodTestDescriptor.class);
    private final Class<?> testClass;
    private final Argument testArgument;
    private final Method testMethod;

    public MethodTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Argument testArgument, Method testMethod) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testArgument = testArgument;
        this.testMethod = testMethod;
        this.testMethod.setAccessible(true);
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)this.testMethod));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    public boolean isTest() {
        return true;
    }

    public boolean isContainer() {
        return false;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Argument getTestArgument() {
        return this.testArgument;
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TestEngineExecutionContext testEngineExecutionContext) {
        ThrowableCollector throwableCollector = this.getThrowableCollector();
        EngineExecutionListener engineExecutionListener = testEngineExecutionContext.getExecutionRequest().getEngineExecutionListener();
        engineExecutionListener.executionStarted((TestDescriptor)this);
        Object testInstance = testEngineExecutionContext.getTestInstance();
        Class<?> testClass = testInstance.getClass();
        String testClassName = testClass.getName();
        try {
            LOGGER.trace("invoking [%s] @TestEngine.BeforeEach methods", (Object)testClassName);
            TestEngineReflectionUtils.getBeforeEachMethods(testClass).forEach(method -> {
                LOGGER.trace("invoking [%s] @TestEngine.BeforeEach method [%s]", testClassName, method.getName());
                try {
                    method.invoke(testInstance, (Object[])null);
                }
                finally {
                    this.flush();
                }
            });
        }
        catch (Throwable t) {
            t = this.pruneStackTrace(t, testClassName);
            System.out.println("-->");
            t.printStackTrace();
            System.out.println("<--");
            throwableCollector.add(t);
        }
        if (throwableCollector.isEmpty()) {
            try {
                LOGGER.trace("invoking [%s] @TestEngine.Test method [%s]", testClassName, this.testMethod.getName());
                try {
                    this.testMethod.invoke(testInstance, (Object[])null);
                }
                finally {
                    this.flush();
                }
            }
            catch (Throwable t) {
                t = this.pruneStackTrace(t, testClassName);
                t.printStackTrace();
                throwableCollector.add(t);
            }
        }
        try {
            LOGGER.trace("invoking [%s] @TestEngine.AfterEach methods", (Object)testClassName);
            TestEngineReflectionUtils.getAfterEachMethods(testClass).forEach(method -> {
                LOGGER.trace("invoking [%s] @TestEngine.AfterEach method [%s]", testClassName, method.getName());
                try {
                    method.invoke(testInstance, (Object[])null);
                }
                finally {
                    this.flush();
                }
            });
        }
        catch (Throwable t) {
            t = this.pruneStackTrace(t, testClassName);
            t.printStackTrace();
            throwableCollector.add(t);
        }
        if (throwableCollector.isEmpty()) {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)throwableCollector.getFirst().orElse(null)));
        }
    }
}

