/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery.resolver;

import java.util.List;
import java.util.function.Predicate;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.discovery.PackageNameFilter;

public class PackageNameFiltersPredicate
implements Predicate<Class<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PackageNameFiltersPredicate.class);
    private final List<PackageNameFilter> packageNameFilters;

    public PackageNameFiltersPredicate(List<PackageNameFilter> packageNameFilters) {
        this.packageNameFilters = packageNameFilters;
    }

    @Override
    public boolean test(Class<?> clazz) {
        String packageName = clazz.getPackage().getName();
        if (this.packageNameFilters == null || this.packageNameFilters.isEmpty()) {
            LOGGER.trace("package [%s] included", (Object)packageName);
            return true;
        }
        for (PackageNameFilter packageNameFilter : this.packageNameFilters) {
            FilterResult filterResult = packageNameFilter.apply((Object)clazz.getName());
            if (!filterResult.excluded()) continue;
            LOGGER.trace("package [%s] excluded", (Object)packageName);
            return false;
        }
        LOGGER.trace("package [%s] included", (Object)packageName);
        return true;
    }
}

