/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.TestEngineConfiguration;
import org.antublue.test.engine.internal.TestEngineException;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.TestDescriptorUtils;
import org.antublue.test.engine.internal.discovery.predicate.TestClassPredicate;
import org.antublue.test.engine.internal.discovery.predicate.TestClassTagPredicate;
import org.antublue.test.engine.internal.discovery.predicate.TestMethodPredicate;
import org.antublue.test.engine.internal.discovery.predicate.TestMethodTagPredicate;
import org.antublue.test.engine.internal.discovery.resolver.ClassNameFiltersPredicate;
import org.antublue.test.engine.internal.discovery.resolver.PackageNameFiltersPredicate;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.DiscoveryFilter;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.EngineDiscoveryListener;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class TestEngineEngineDiscoveryRequest
implements EngineDiscoveryRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngineEngineDiscoveryRequest.class);
    private final TestClassPredicate includeTestClassPredicate;
    private final TestClassPredicate excludeTestClassPredicate;
    private final TestMethodPredicate includeTestMethodPredicate;
    private final TestMethodPredicate excludeTestMethodPredicate;
    private final TestClassTagPredicate includeTestClassTagPredicate;
    private final TestClassTagPredicate excludeTestClassTagPredicate;
    private final TestMethodTagPredicate includeTestMethodTagPredicate;
    private final TestMethodTagPredicate excludeTestMethodTagPredicate;
    private final ConfigurationParameters configurationParameters;
    private final EngineDiscoveryRequest engineDiscoveryRequest;
    private final EngineDescriptor engineDescriptor;
    private static final Predicate<Class<?>> IS_TEST_CLASS = clazz -> {
        if (clazz.isAnnotationPresent(TestEngine.BaseClass.class) || clazz.isAnnotationPresent(TestEngine.Disabled.class)) {
            LOGGER.trace("class [%s] excluded", (Object)clazz.getName());
            return false;
        }
        if (Modifier.isAbstract(clazz.getModifiers()) || TestEngineReflectionUtils.getTestMethods(clazz).isEmpty()) {
            LOGGER.trace("class [%s] excluded", (Object)clazz.getName());
            return false;
        }
        LOGGER.trace("class [%s] included", (Object)clazz.getName());
        return true;
    };
    private static final Predicate<Method> IS_TEST_METHOD = method -> {
        boolean result = TestEngineReflectionUtils.getTestMethods(method.getDeclaringClass()).contains(method);
        LOGGER.trace("class [%s] = [%b]", method.getDeclaringClass().getName(), result);
        return result;
    };

    public TestEngineEngineDiscoveryRequest(EngineDiscoveryRequest engineDiscoveryRequest, ConfigurationParameters configurationParameters, EngineDescriptor engineDescriptor) {
        this.engineDiscoveryRequest = engineDiscoveryRequest;
        this.configurationParameters = configurationParameters;
        this.engineDescriptor = engineDescriptor;
        this.includeTestClassPredicate = TestEngineConfiguration.getInstance().get("antublue.test.engine.test.class.include").map(value -> {
            LOGGER.trace("%s [%s]", "antublue.test.engine.test.class.include", value);
            return value;
        }).map(TestClassPredicate::of).orElse(null);
        this.excludeTestClassPredicate = TestEngineConfiguration.getInstance().get("antublue.test.engine.test.class.exclude").map(value -> {
            LOGGER.trace("%s [%s]", "antublue.test.engine.test.class.exclude", value);
            return value;
        }).map(TestClassPredicate::of).orElse(null);
        this.includeTestMethodPredicate = TestEngineConfiguration.getInstance().get("antublue.test.engine.test.method.include").map(value -> {
            LOGGER.trace("%s [%s]", "antublue.test.engine.test.method.include", value);
            return value;
        }).map(TestMethodPredicate::of).orElse(null);
        this.excludeTestMethodPredicate = TestEngineConfiguration.getInstance().get("antublue.test.engine.test.method.exclude").map(value -> {
            LOGGER.trace("%s [%s]", "antublue.test.engine.test.method.exclude", value);
            return value;
        }).map(TestMethodPredicate::of).orElse(null);
        this.includeTestClassTagPredicate = TestEngineConfiguration.getInstance().get("antublue.test.engine.test.class.tag.include").map(value -> {
            LOGGER.trace("%s [%s]", "antublue.test.engine.test.class.tag.include", value);
            return value;
        }).map(TestClassTagPredicate::of).orElse(null);
        this.excludeTestClassTagPredicate = TestEngineConfiguration.getInstance().get("antublue.test.engine.test.class.tag.exclude").map(value -> {
            LOGGER.trace("%s [%s]", "antublue.test.engine.test.class.tag.exclude", value);
            return value;
        }).map(TestClassTagPredicate::of).orElse(null);
        this.includeTestMethodTagPredicate = TestEngineConfiguration.getInstance().get("antublue.test.engine.test.method.tag.include").map(value -> {
            LOGGER.trace("%s [%s]", "antublue.test.engine.test.method.tag.include", value);
            return value;
        }).map(TestMethodTagPredicate::of).orElse(null);
        this.excludeTestMethodTagPredicate = TestEngineConfiguration.getInstance().get("antublue.test.engine.test.method.tag.exclude").map(value -> {
            LOGGER.trace("%s [%s]", "antublue.test.engine.test.method.tag.exclude", value);
            return value;
        }).map(TestMethodTagPredicate::of).orElse(null);
    }

    public <T extends DiscoverySelector> List<T> getSelectorsByType(Class<T> clazz) {
        return this.engineDiscoveryRequest.getSelectorsByType(clazz);
    }

    public <T extends DiscoveryFilter<?>> List<T> getFiltersByType(Class<T> clazz) {
        return this.engineDiscoveryRequest.getFiltersByType(clazz);
    }

    public ConfigurationParameters getConfigurationParameters() {
        return this.configurationParameters;
    }

    public EngineDiscoveryListener getDiscoveryListener() {
        return this.engineDiscoveryRequest.getDiscoveryListener();
    }

    public void resolve() {
        LOGGER.trace("resolve()");
        List<ClassNameFilter> classNameFilters = this.getFiltersByType(ClassNameFilter.class);
        LOGGER.trace("classNameFilters count [%d]", (Object)classNameFilters.size());
        ClassNameFiltersPredicate classNameFiltersPredicate = new ClassNameFiltersPredicate(classNameFilters);
        List<PackageNameFilter> packageNameFilters = this.getFiltersByType(PackageNameFilter.class);
        LOGGER.trace("packageNameFilters count [%d]", (Object)packageNameFilters.size());
        PackageNameFiltersPredicate packageNameFiltersPredicate = new PackageNameFiltersPredicate(packageNameFilters);
        LinkedHashMap classMethodSetMap = new LinkedHashMap();
        this.getSelectorsByType(ClasspathRootSelector.class).forEach(classpathRootSelector -> {
            LOGGER.trace("ClasspathRootSelector.class");
            TestEngineReflectionUtils.findAllClasses(classpathRootSelector.getClasspathRoot()).forEach(clazz -> {
                if (IS_TEST_CLASS.test((Class<?>)clazz) && packageNameFiltersPredicate.test((Class<?>)clazz) && classNameFiltersPredicate.test((Class<?>)clazz)) {
                    classMethodSetMap.put(clazz, new LinkedHashSet<Method>(TestEngineReflectionUtils.getTestMethods(clazz)));
                }
            });
        });
        this.getSelectorsByType(PackageSelector.class).forEach(packageSelector -> {
            LOGGER.trace("PackageSelector.class");
            TestEngineReflectionUtils.findAllClasses(packageSelector.getPackageName()).forEach(clazz -> {
                if (IS_TEST_CLASS.test((Class<?>)clazz) && packageNameFiltersPredicate.test((Class<?>)clazz) && classNameFiltersPredicate.test((Class<?>)clazz)) {
                    classMethodSetMap.put(clazz, new LinkedHashSet<Method>(TestEngineReflectionUtils.getTestMethods(clazz)));
                }
            });
        });
        this.getSelectorsByType(ClassSelector.class).forEach(classSelector -> {
            LOGGER.trace("ClassSelector.class");
            Class clazz = classSelector.getJavaClass();
            if (IS_TEST_CLASS.test(clazz) && packageNameFiltersPredicate.test(clazz) && classNameFiltersPredicate.test(clazz)) {
                classMethodSetMap.put(clazz, new LinkedHashSet<Method>(TestEngineReflectionUtils.getTestMethods(clazz)));
            }
        });
        this.getSelectorsByType(MethodSelector.class).forEach(methodSelector -> {
            LOGGER.trace("MethodSelector.class");
            Class clazz = methodSelector.getJavaClass();
            if (IS_TEST_METHOD.test(methodSelector.getJavaMethod()) && packageNameFiltersPredicate.test(clazz) && classNameFiltersPredicate.test(clazz)) {
                Set methods = classMethodSetMap.getOrDefault(clazz, new LinkedHashSet());
                methods.add(methodSelector.getJavaMethod());
                classMethodSetMap.put(clazz, methods);
            }
        });
        this.getSelectorsByType(UniqueIdSelector.class).forEach(uniqueIdSelector -> {
            LOGGER.trace("UniqueIdSelector.class");
            UniqueId.Segment segment = uniqueIdSelector.getUniqueId().getLastSegment();
            if ("class".equals(segment.getType())) {
                String className = segment.getValue();
                try {
                    Class<?> clazz = Class.forName(className);
                    if (!IS_TEST_CLASS.test(clazz) || !packageNameFiltersPredicate.test(clazz) || !classNameFiltersPredicate.test(clazz)) return;
                    Set methods = classMethodSetMap.getOrDefault(clazz, new LinkedHashSet());
                    methods.addAll(TestEngineReflectionUtils.getTestMethods(clazz));
                    classMethodSetMap.put(clazz, methods);
                    return;
                }
                catch (ClassNotFoundException e) {
                    throw new TestEngineException(String.format("Exception loading class [%s]", className));
                }
            }
            if (!"argument".equals(segment.getType())) return;
            segment = uniqueIdSelector.getUniqueId().removeLastSegment().getLastSegment();
            String className = segment.getValue();
            try {
                Class<?> clazz = Class.forName(className);
                if (!IS_TEST_CLASS.test(clazz) || !packageNameFiltersPredicate.test(clazz) || !classNameFiltersPredicate.test(clazz)) return;
                Set methods = classMethodSetMap.getOrDefault(clazz, new LinkedHashSet());
                methods.addAll(TestEngineReflectionUtils.getTestMethods(clazz));
                classMethodSetMap.put(clazz, methods);
                return;
            }
            catch (ClassNotFoundException e) {
                throw new TestEngineException(String.format("Exception loading class [%s]", className));
            }
        });
        Iterator classMethodMapEntryIterator = classMethodSetMap.entrySet().iterator();
        while (classMethodMapEntryIterator.hasNext()) {
            Map.Entry entry = classMethodMapEntryIterator.next();
            Class clazz = (Class)entry.getKey();
            Set methods = (Set)entry.getValue();
            if (this.includeTestClassPredicate != null) {
                if (this.includeTestClassPredicate.test(clazz)) {
                    LOGGER.trace("includeTestClassPredicate class [%s] included", (Object)clazz.getName());
                } else {
                    LOGGER.trace("includeTestClassPredicate class [%s] excluded", (Object)clazz.getName());
                    classMethodMapEntryIterator.remove();
                    continue;
                }
            }
            if (this.excludeTestClassPredicate != null) {
                if (this.excludeTestClassPredicate.test(clazz)) {
                    LOGGER.trace("excludeTestClassPredicate class [%s] excluded", (Object)clazz.getName());
                    classMethodMapEntryIterator.remove();
                    continue;
                }
                LOGGER.trace("excludeTestClassPredicate class [%s] included", (Object)clazz.getName());
            }
            if (this.includeTestClassTagPredicate != null) {
                if (this.includeTestClassTagPredicate.test(clazz)) {
                    LOGGER.trace("includeTestClassTagPredicate class [%s] included", (Object)clazz.getName());
                } else {
                    LOGGER.trace("includeTestClassTagPredicate class [%s] excluded", (Object)clazz.getName());
                    classMethodMapEntryIterator.remove();
                    continue;
                }
            }
            if (this.excludeTestClassTagPredicate != null) {
                if (this.excludeTestClassTagPredicate.test(clazz)) {
                    LOGGER.trace("excludeTestClassTagPredicate class [%s] excluded", (Object)clazz.getName());
                    classMethodMapEntryIterator.remove();
                    continue;
                }
                LOGGER.trace("excludeTestClassTagPredicate class [%s] included", (Object)clazz.getName());
            }
            Iterator methodIterator = methods.iterator();
            while (methodIterator.hasNext()) {
                Method method = (Method)methodIterator.next();
                if (this.includeTestMethodPredicate != null) {
                    if (this.includeTestMethodPredicate.test(method)) {
                        LOGGER.trace("includeTestMethodPredicate class [%s] included", (Object)method.getName());
                    } else {
                        LOGGER.trace("includeTestMethodPredicate class [%s] excluded", (Object)method.getName());
                        methodIterator.remove();
                        continue;
                    }
                }
                if (this.excludeTestMethodPredicate != null) {
                    if (this.excludeTestMethodPredicate.test(method)) {
                        LOGGER.trace("excludeTestMethodPredicate class [%s] excluded", (Object)method.getName());
                        methodIterator.remove();
                        continue;
                    }
                    LOGGER.trace("excludeTestMethodPredicate class [%s] included", (Object)method.getName());
                }
                if (this.includeTestMethodTagPredicate != null) {
                    if (this.includeTestMethodTagPredicate.test(method)) {
                        LOGGER.trace("includeTestMethodTagPredicate class [%s] included", (Object)method.getName());
                    } else {
                        LOGGER.trace("includeTestMethodTagPredicate class [%s] excluded", (Object)method.getName());
                        methodIterator.remove();
                        continue;
                    }
                }
                if (this.excludeTestMethodTagPredicate == null) continue;
                if (this.excludeTestMethodTagPredicate.test(method)) {
                    LOGGER.trace("excludeTestMethodTagPredicate class [%s] excluded", (Object)method.getName());
                    methodIterator.remove();
                    continue;
                }
                LOGGER.trace("excludeTestMethodTagPredicate class [%s] included", (Object)method.getName());
            }
            if (methods.isEmpty()) {
                LOGGER.trace("class [%s] has no test methods, ignoring", (Object)clazz.getName());
                classMethodMapEntryIterator.remove();
                continue;
            }
            LOGGER.trace("building test descriptor tree for class [%s]", (Object)clazz.getName());
            UniqueId classTestDescritporUniqueId = this.engineDescriptor.getUniqueId().append("class", clazz.getName());
            ClassTestDescriptor classTestDescriptor = TestDescriptorUtils.createClassTestDescriptor(classTestDescritporUniqueId, clazz);
            this.engineDescriptor.addChild((TestDescriptor)classTestDescriptor);
            List<Argument> arguments = TestEngineReflectionUtils.getArgumentsList(clazz);
            for (Argument argument : arguments) {
                UniqueId argumentUniqueId = classTestDescritporUniqueId.append("argument", argument.name());
                ArgumentTestDescriptor argumentTestDescriptor = TestDescriptorUtils.createArgumentTestDescriptor(argumentUniqueId, clazz, argument);
                classTestDescriptor.addChild((TestDescriptor)argumentTestDescriptor);
                for (Method method : methods) {
                    UniqueId methodUniqueId = argumentUniqueId.append("method", method.getName());
                    MethodTestDescriptor methodTestDescriptor = TestDescriptorUtils.createMethodTestDescriptor(methodUniqueId, clazz, argument, method);
                    argumentTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
                }
            }
        }
        TestDescriptorUtils.logTestDescriptorTree((TestDescriptor)this.engineDescriptor);
    }
}

