/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.util.Optional;
import org.antublue.test.engine.internal.TestEngineExecutionContext;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ExtendedAbstractTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;

public final class ClassTestDescriptor
extends ExtendedAbstractTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassTestDescriptor.class);
    private final Class<?> testClass;

    public ClassTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass) {
        super(uniqueId, displayName);
        this.testClass = testClass;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testClass));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public boolean isTest() {
        return false;
    }

    public boolean isContainer() {
        return true;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TestEngineExecutionContext testEngineExecutionContext) {
        Object finalTestInstance;
        ThrowableCollector throwableCollector = this.getThrowableCollector();
        EngineExecutionListener engineExecutionListener = testEngineExecutionContext.getExecutionRequest().getEngineExecutionListener();
        engineExecutionListener.executionStarted((TestDescriptor)this);
        String testClassName = this.testClass.getName();
        Object testInstance = null;
        try {
            LOGGER.trace("creating class [%s]", (Object)testClassName);
            try {
                testInstance = this.testClass.getDeclaredConstructor(null).newInstance(null);
                testEngineExecutionContext.setTestInstance(testInstance);
            }
            finally {
                this.flush();
            }
            finalTestInstance = testInstance;
            TestEngineReflectionUtils.getPrepareMethods(this.testClass).forEach(method -> {
                LOGGER.trace("invoking [%s] @TestEngine.Prepare method [%s]", testClassName, method.getName());
                try {
                    method.invoke(finalTestInstance, (Object[])null);
                }
                finally {
                    this.flush();
                }
            });
        }
        catch (Throwable t) {
            t = this.pruneStackTrace(t, testClassName);
            t.printStackTrace();
            throwableCollector.add(t);
        }
        if (throwableCollector.isEmpty()) {
            this.getChildren(ArgumentTestDescriptor.class).forEach(argumentTestDescriptor -> argumentTestDescriptor.execute(testEngineExecutionContext));
        } else {
            this.getChildren(ArgumentTestDescriptor.class).forEach(argumentTestDescriptor -> argumentTestDescriptor.skip(testEngineExecutionContext));
        }
        try {
            if (testInstance != null) {
                finalTestInstance = testInstance;
                TestEngineReflectionUtils.getConcludeMethods(this.testClass).forEach(method -> {
                    LOGGER.trace("invoking [%s] @TestEngine.Conclude method [%s]", testClassName, method.getName());
                    try {
                        method.invoke(finalTestInstance, (Object[])null);
                    }
                    finally {
                        this.flush();
                    }
                });
            }
        }
        catch (Throwable t) {
            t = this.pruneStackTrace(t, testClassName);
            t.printStackTrace();
            throwableCollector.add(t);
        }
        if (throwableCollector.isEmpty()) {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)throwableCollector.getFirst().orElse(null)));
        }
        testEngineExecutionContext.setTestInstance(null);
        testEngineExecutionContext.getCountDownLatch().countDown();
    }
}

