/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import java.math.BigInteger;
import org.antublue.test.engine.api.Argument;

public class BigIntegerArgument
implements Argument {
    private final String name;
    private final BigInteger value;

    public BigIntegerArgument(String name, BigInteger value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if ((name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public BigInteger value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BigIntegerArgument of(BigInteger value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        return new BigIntegerArgument(String.valueOf(value).toUpperCase(), value);
    }
}

