/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import org.antublue.test.engine.api.Argument;

public class BooleanArgument
implements Argument {
    private final String name;
    private final boolean value;

    public BooleanArgument(String name, boolean value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if ((name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public boolean value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BooleanArgument of(boolean value) {
        return new BooleanArgument(String.valueOf(value).toUpperCase(), value);
    }
}

