/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import org.antublue.test.engine.api.Argument;

public class ByteArgument
implements Argument {
    private final String name;
    private final byte value;

    public ByteArgument(String name, byte value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if ((name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public byte value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ByteArgument of(byte value) {
        return new ByteArgument(String.valueOf(value).toUpperCase(), value);
    }
}

