/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import org.antublue.test.engine.api.Argument;

public class CharArgument
implements Argument {
    private final String name;
    private final char value;

    public CharArgument(String name, char value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if ((name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public char value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CharArgument of(char value) {
        return new CharArgument(String.valueOf(value).toUpperCase(), value);
    }
}

