/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import org.antublue.test.engine.api.Argument;

public class DoubleArgument
implements Argument {
    private final String name;
    private final double value;

    public DoubleArgument(String name, double value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if ((name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public double value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DoubleArgument of(double value) {
        return new DoubleArgument(String.valueOf(value).toUpperCase(), value);
    }
}

