/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import org.antublue.test.engine.api.Argument;

public class FloatArgument
implements Argument {
    private final String name;
    private final float value;

    public FloatArgument(String name, float value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if ((name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public float value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FloatArgument of(float value) {
        return new FloatArgument(String.valueOf(value).toUpperCase(), value);
    }
}

