/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import org.antublue.test.engine.api.Argument;

public class IntegerArgument
implements Argument {
    private final String name;
    private final int value;

    public IntegerArgument(String name, int value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if ((name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public int value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IntegerArgument of(int value) {
        return new IntegerArgument(String.valueOf(value).toUpperCase(), value);
    }
}

