/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import org.antublue.test.engine.api.Argument;

public class LongArgument
implements Argument {
    private final String name;
    private final long value;

    public LongArgument(String name, long value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if ((name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public long value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LongArgument of(long value) {
        return new LongArgument(String.valueOf(value).toUpperCase(), value);
    }
}

