/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import org.antublue.test.engine.api.Argument;

public class ObjectArgument<T>
implements Argument {
    private final String name;
    private final T value;

    public ObjectArgument(String name, T value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if ((name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public T value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static <T> ObjectArgument<T> of(String name, T value) {
        return new ObjectArgument<T>(name, value);
    }
}

