/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import org.antublue.test.engine.api.Argument;

public class ShortArgument
implements Argument {
    private final String name;
    private final short value;

    public ShortArgument(String name, short value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if ((name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public short value() {
        return this.value;
    }

    public static ShortArgument of(short value) {
        return new ShortArgument(String.valueOf(value).toUpperCase(), value);
    }
}

