/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import org.antublue.test.engine.api.Argument;

public class StringArgument
implements Argument {
    private final String name;
    private final String value;

    public StringArgument(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if ((name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public static StringArgument of(String value) {
        String name = value;
        if (name == null) {
            name = "((null))";
        } else if (name.isEmpty()) {
            name = "((empty))";
        }
        return new StringArgument(name, value);
    }
}

