/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.source;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.antublue.test.engine.api.argument.StringArgument;

public final class LineSource {
    private LineSource() {
    }

    public static Stream<StringArgument> of(File file, Charset charset) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
            Stream<StringArgument> stream = LineSource.of(inputStream, charset);
            return stream;
        }
    }

    public static Stream<StringArgument> of(Reader reader) throws IOException {
        ArrayList<StringArgument> list = new ArrayList<StringArgument>();
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            long index = 0L;
            while ((line = bufferedReader.readLine()) != null) {
                list.add(new StringArgument("line[" + index + "]", line));
                ++index;
            }
        }
        return list.stream();
    }

    public static Stream<StringArgument> of(InputStream inputStream, Charset charset) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, charset);){
            Stream<StringArgument> stream = LineSource.of(reader);
            return stream;
        }
    }
}

