/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.TestClassConfigurationException;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.Throwables;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.ReflectionUtils;

public final class TestEngineReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngineReflectionUtils.class);
    private static final Map<Class<?>, Method> argumentSupplierMethodCache = new HashMap();
    private static final Map<Class<?>, Field> argumentFieldCaches;
    private static final Map<Class<?>, List<Method>> prepareMethodCache;
    private static final Map<Class<?>, List<Method>> beforeAllMethodCache;
    private static final Map<Class<?>, List<Method>> beforeEachMethodCache;
    private static final Map<Class<?>, List<Method>> testMethodCache;
    private static final Map<Class<?>, List<Method>> afterEachMethodCache;
    private static final Map<Class<?>, List<Method>> afterAllMethodCache;
    private static final Map<Class<?>, List<Method>> concludeMethodCache;

    private TestEngineReflectionUtils() {
    }

    public static List<Class<?>> findAllClasses(URI uri) {
        List<Class<?>> classes = ReflectionUtils.findAllClassesInClasspathRoot(uri, classFilter -> true, classNameFilter -> true);
        classes = new ArrayList(classes);
        TestEngineReflectionUtils.sortClasses(classes);
        TestEngineReflectionUtils.validateDistinctOrder(classes);
        return classes;
    }

    public static List<Class<?>> findAllClasses(String packageName) {
        List<Class<?>> classes = ReflectionSupport.findAllClassesInPackage(packageName, classFilter -> true, classNameFilter -> true);
        classes = new ArrayList(classes);
        TestEngineReflectionUtils.sortClasses(classes);
        TestEngineReflectionUtils.validateDistinctOrder(classes);
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method getArgumentSupplierMethod(Class<?> clazz) {
        Map<Class<?>, Method> map = argumentSupplierMethodCache;
        synchronized (map) {
            LOGGER.trace("getArgumentSupplierMethod(%s)", (Object)clazz.getName());
            if (argumentSupplierMethodCache.containsKey(clazz)) {
                return argumentSupplierMethodCache.get(clazz);
            }
            List<Method> methodList = TestEngineReflectionUtils.getMethods(clazz, TestEngine.ArgumentSupplier.class, Scope.STATIC, Stream.class, null);
            if (methodList.size() == 0) {
                methodList = TestEngineReflectionUtils.getMethods(clazz, TestEngine.ArgumentSupplier.class, Scope.STATIC, Iterable.class, null);
            }
            LOGGER.trace("class [%s] @TestEngine.ArgumentSupplier method count [%d]", clazz.getName(), methodList.size());
            if (methodList.size() != 1) {
                throw new TestClassConfigurationException(String.format("Test class [%s] must define one @TestEngine.ArgumentSupplier method", clazz.getName()));
            }
            Method method = methodList.get(0);
            argumentSupplierMethodCache.put(clazz, method);
            return method;
        }
    }

    public static List<Argument> getArgumentsList(Class<?> clazz) {
        LOGGER.trace("getArgumentsList(%s)", (Object)clazz.getName());
        try {
            Method method = TestEngineReflectionUtils.getArgumentSupplierMethod(clazz);
            Object object = method.invoke(null, (Object[])null);
            if (object instanceof Stream) {
                List<Argument> arguments = ((Stream)object).collect(Collectors.toList());
                LOGGER.trace("class [%s] argument count [%d]", clazz.getName(), arguments.size());
                return arguments;
            }
            if (object instanceof Iterable) {
                ArrayList<Argument> arguments = new ArrayList<Argument>();
                ((Iterable)object).forEach(arguments::add);
                LOGGER.trace("class [%s] argument count [%d]", clazz.getName(), arguments.size());
                return arguments;
            }
            throw new TestClassConfigurationException(String.format("Test class [%s] must define one @TestEngine.ArgumentSupplier method", clazz.getName()));
        }
        catch (TestClassConfigurationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TestClassConfigurationException(String.format("Can't get Stream<Argument> or Iterable<Argument> from test class [%s]", clazz.getName()), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getPrepareMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = prepareMethodCache;
        synchronized (map) {
            LOGGER.trace("getPrepareMethods(%s)", (Object)clazz.getName());
            if (prepareMethodCache.containsKey(clazz)) {
                return prepareMethodCache.get(clazz);
            }
            List<Method> methods = TestEngineReflectionUtils.getMethods(clazz, TestEngine.Prepare.class, Scope.NON_STATIC, Void.class, null);
            LOGGER.trace("class [%s] @TestEngine.Prepare method count [%d]", clazz.getName(), methods.size());
            if (!methods.isEmpty()) {
                TestEngineReflectionUtils.sortMethods(methods);
                TestEngineReflectionUtils.validateDistinctOrder(clazz, methods);
            }
            methods = Collections.unmodifiableList(methods);
            prepareMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Field getArgumentField(Class<?> clazz) {
        Map<Class<?>, Field> map = argumentFieldCaches;
        synchronized (map) {
            LOGGER.trace("getArgumentField(%s)", (Object)clazz.getName());
            if (argumentFieldCaches.containsKey(clazz)) {
                return argumentFieldCaches.get(clazz);
            }
            List<Field> argumentFields = TestEngineReflectionUtils.getFields(clazz, TestEngine.Argument.class, Argument.class);
            LOGGER.trace("class [%s] @TestEngine.Argument field count [%d]", clazz.getName(), argumentFields.size());
            if (argumentFields.size() != 1) {
                throw new TestClassConfigurationException(String.format("Test class [%s] must define one @TestEngine.Argument field", clazz.getName()));
            }
            argumentFieldCaches.put(clazz, argumentFields.get(0));
            return argumentFields.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getBeforeAllMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = beforeAllMethodCache;
        synchronized (map) {
            LOGGER.trace("getBeforeAllMethods(%s)", (Object)clazz.getName());
            if (beforeAllMethodCache.containsKey(clazz)) {
                return beforeAllMethodCache.get(clazz);
            }
            List<Method> methods = TestEngineReflectionUtils.getMethods(clazz, TestEngine.BeforeAll.class, Scope.NON_STATIC, Void.class, null);
            LOGGER.trace("class [%s] @TestEngine.BeforeAll method count [%d]", clazz.getName(), methods.size());
            if (!methods.isEmpty()) {
                TestEngineReflectionUtils.sortMethods(methods);
                TestEngineReflectionUtils.validateDistinctOrder(clazz, methods);
            }
            methods = Collections.unmodifiableList(methods);
            beforeAllMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getBeforeEachMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = beforeEachMethodCache;
        synchronized (map) {
            LOGGER.trace("getBeforeEachMethods(%s)", (Object)clazz.getName());
            if (beforeEachMethodCache.containsKey(clazz)) {
                return beforeEachMethodCache.get(clazz);
            }
            List<Method> methods = TestEngineReflectionUtils.getMethods(clazz, TestEngine.BeforeEach.class, Scope.NON_STATIC, Void.class, null);
            LOGGER.trace("class [%s] @TestEngine.BeforeEach method count [%d]", clazz.getName(), methods.size());
            if (!methods.isEmpty()) {
                TestEngineReflectionUtils.sortMethods(methods);
                TestEngineReflectionUtils.validateDistinctOrder(clazz, methods);
            }
            methods = Collections.unmodifiableList(methods);
            beforeEachMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getTestMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = testMethodCache;
        synchronized (map) {
            LOGGER.trace("getTestMethods(%s)", (Object)clazz.getName());
            if (testMethodCache.containsKey(clazz)) {
                return new ArrayList<Method>((Collection)testMethodCache.get(clazz));
            }
            List<Method> methods = TestEngineReflectionUtils.getMethods(clazz, TestEngine.Test.class, Scope.NON_STATIC, Void.class, null).stream().filter(method -> !method.isAnnotationPresent(TestEngine.Disabled.class)).collect(Collectors.toList());
            LOGGER.trace("class [%s] @TestEngine.Test method count [%d]", clazz.getName(), methods.size());
            if (!methods.isEmpty()) {
                TestEngineReflectionUtils.sortMethods(methods);
                TestEngineReflectionUtils.validateDistinctOrder(clazz, methods);
                methods = Collections.unmodifiableList(methods);
            }
            testMethodCache.put(clazz, methods);
            return new ArrayList<Method>(methods);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getAfterEachMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = afterEachMethodCache;
        synchronized (map) {
            LOGGER.trace("getAfterEachMethods(%s)", (Object)clazz.getName());
            if (afterEachMethodCache.containsKey(clazz)) {
                return afterEachMethodCache.get(clazz);
            }
            List<Method> methods = TestEngineReflectionUtils.getMethods(clazz, TestEngine.AfterEach.class, Scope.NON_STATIC, Void.class, null);
            LOGGER.trace("class [%s] @TestEngine.AfterEach method count [%d]", clazz.getName(), methods.size());
            if (!methods.isEmpty()) {
                TestEngineReflectionUtils.sortMethods(methods);
                TestEngineReflectionUtils.validateDistinctOrder(clazz, methods);
            }
            methods = Collections.unmodifiableList(methods);
            afterEachMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getAfterAllMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = afterAllMethodCache;
        synchronized (map) {
            LOGGER.trace("getAfterAllMethods(%s)", (Object)clazz.getName());
            if (afterAllMethodCache.containsKey(clazz)) {
                return afterAllMethodCache.get(clazz);
            }
            List<Method> methods = TestEngineReflectionUtils.getMethods(clazz, TestEngine.AfterAll.class, Scope.NON_STATIC, Void.class, null);
            LOGGER.trace("class [%s] @TestEngine.AfterAll method count [%d]", clazz.getName(), methods.size());
            if (!methods.isEmpty()) {
                TestEngineReflectionUtils.sortMethods(methods);
                TestEngineReflectionUtils.validateDistinctOrder(clazz, methods);
            }
            methods = Collections.unmodifiableList(methods);
            afterAllMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getConcludeMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = concludeMethodCache;
        synchronized (map) {
            LOGGER.trace("getConcludeMethods(%s)", (Object)clazz.getName());
            if (concludeMethodCache.containsKey(clazz)) {
                return concludeMethodCache.get(clazz);
            }
            List<Method> methods = TestEngineReflectionUtils.getMethods(clazz, TestEngine.Conclude.class, Scope.NON_STATIC, Void.class, null);
            LOGGER.trace("class [%s] @TestEngine.Conclude method count [%d]", clazz.getName(), methods.size());
            if (!methods.isEmpty()) {
                TestEngineReflectionUtils.sortMethods(methods);
                TestEngineReflectionUtils.validateDistinctOrder(clazz, methods);
            }
            methods = Collections.unmodifiableList(methods);
            concludeMethodCache.put(clazz, methods);
            return methods;
        }
    }

    public static String getDisplayName(Method method) {
        String value;
        String displayName = method.getName();
        if (method.isAnnotationPresent(TestEngine.DisplayName.class) && (value = method.getAnnotation(TestEngine.DisplayName.class).value()) != null && !value.trim().isEmpty()) {
            displayName = value.trim();
        }
        LOGGER.trace("method [%s] display name [%s]", method.getName(), displayName);
        return displayName;
    }

    public static String getDisplayName(Class<?> clazz) {
        String value;
        String displayName = clazz.getName();
        if (clazz.isAnnotationPresent(TestEngine.DisplayName.class) && (value = clazz.getAnnotation(TestEngine.DisplayName.class).value()) != null && !value.trim().isEmpty()) {
            displayName = value.trim();
        }
        LOGGER.trace("class [%s] display name [%s]", clazz.getName(), displayName);
        return displayName;
    }

    private static List<Field> getFields(Class<?> clazz, Class<? extends Annotation> annotation, Class<?> fieldType) {
        LOGGER.trace("getFields(%s, %s, %s)", clazz.getName(), annotation.getName(), fieldType.getName());
        LinkedHashSet<Field> fieldSet = new LinkedHashSet<Field>();
        TestEngineReflectionUtils.resolveFields(clazz, annotation, fieldType, fieldSet);
        ArrayList<Field> fields = new ArrayList<Field>(fieldSet);
        fields.sort(Comparator.comparing(Field::getName));
        LOGGER.trace("class [%s] argument field count [%d]", clazz.getName(), fieldSet.size());
        return fields;
    }

    private static void resolveFields(Class<?> clazz, Class<? extends Annotation> annotation, Class<?> fieldType, Set<Field> fieldSet) {
        LOGGER.trace("resolveFields(%s, %s, %s)", clazz.getName(), annotation.getName(), fieldType.getName());
        Stream.of(clazz.getDeclaredFields()).filter(field -> {
            int modifiers = field.getModifiers();
            return !Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers) && field.isAnnotationPresent(annotation) && fieldType.isAssignableFrom(field.getType());
        }).forEach(field -> {
            field.setAccessible(true);
            fieldSet.add((Field)field);
        });
        Class<?> declaringClass = clazz.getSuperclass();
        if (declaringClass != null && !declaringClass.equals(Object.class)) {
            TestEngineReflectionUtils.resolveFields(declaringClass, annotation, fieldType, fieldSet);
        }
    }

    private static List<Method> getMethods(Class<?> clazz, Class<? extends Annotation> annotation, Scope scope, Class<?> returnType, Class<?> ... parameterTypes) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("getMethods(%s, %s, %s, %s", new Object[]{clazz.getName(), annotation.getName(), scope, returnType.getName()}));
        if (parameterTypes != null) {
            for (Class<?> parameterTypeClass : parameterTypes) {
                stringBuilder.append(", ").append(parameterTypeClass.getName());
            }
        }
        stringBuilder.append(")");
        LOGGER.trace(stringBuilder.toString());
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        TestEngineReflectionUtils.resolveMethods(clazz, annotation, scope, returnType, parameterTypes, methodMap);
        ArrayList<Method> methodList = new ArrayList<Method>(methodMap.values());
        methodList.sort(Comparator.comparing(Method::getName));
        return methodList;
    }

    private static void resolveMethods(Class<?> clazz, Class<? extends Annotation> annotation, Scope scope, Class<?> returnType, Class<?>[] parameterTypes, Map<String, Method> methodMap) {
        block6: {
            if (LOGGER.isTraceEnabled()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(String.format("resolveMethods(%s, %s, %s, %s", new Object[]{clazz.getName(), annotation.getName(), scope, returnType.getName()}));
                if (parameterTypes != null) {
                    for (Class<?> parameterTypeClass : parameterTypes) {
                        stringBuilder.append(", ").append(parameterTypeClass.getName());
                    }
                }
                stringBuilder.append(")");
                LOGGER.trace(stringBuilder.toString());
            }
            try {
                Stream.of(clazz.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(annotation)).filter(method -> {
                    int modifiers = method.getModifiers();
                    return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
                }).filter(method -> {
                    int modifiers = method.getModifiers();
                    if (scope == Scope.STATIC && !Modifier.isStatic(modifiers)) {
                        throw new TestClassConfigurationException(String.format("%s method [%s] must be declared static", TestEngineReflectionUtils.getAnnotationDisplayName(annotation), method.getName()));
                    }
                    if (scope != Scope.STATIC && Modifier.isStatic(modifiers)) {
                        throw new TestClassConfigurationException(String.format("%s method [%s] must be not be declared static", TestEngineReflectionUtils.getAnnotationDisplayName(annotation), method.getName()));
                    }
                    return true;
                }).filter(method -> {
                    if (parameterTypes == null) {
                        return method.getParameterTypes().length == 0;
                    }
                    if (parameterTypes.length != method.getParameterCount()) {
                        return false;
                    }
                    Class<?>[] methodParameterTypes = method.getParameterTypes();
                    for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                        if (parameterTypes[i2].isAssignableFrom(methodParameterTypes[i2])) continue;
                        return false;
                    }
                    return true;
                }).filter(method -> {
                    if (returnType == Void.class) {
                        return method.getReturnType().getName().equals("void");
                    }
                    return returnType.isAssignableFrom(method.getReturnType());
                }).forEach(method -> {
                    if (methodMap.putIfAbsent(method.getName(), (Method)method) == null) {
                        method.setAccessible(true);
                    }
                });
            }
            catch (Throwable t) {
                if (t instanceof NoClassDefFoundError) break block6;
                Throwables.throwIfUnchecked(t);
            }
        }
        Class<?> declaringClass = clazz.getSuperclass();
        if (declaringClass != null && !declaringClass.equals(Object.class)) {
            TestEngineReflectionUtils.resolveMethods(declaringClass, annotation, scope, returnType, parameterTypes, methodMap);
        }
    }

    public static void sortClasses(List<Class<?>> classes) {
        classes.sort((o1, o2) -> {
            boolean o1AnnotationPresent = o1.isAnnotationPresent(TestEngine.Order.class);
            boolean o2AnnotationPresent = o2.isAnnotationPresent(TestEngine.Order.class);
            if (o1AnnotationPresent) {
                if (o2AnnotationPresent) {
                    int o1Order = o1.getAnnotation(TestEngine.Order.class).value();
                    int o2Order = o2.getAnnotation(TestEngine.Order.class).value();
                    return Integer.compare(o1Order, o2Order);
                }
                return -1;
            }
            if (o2AnnotationPresent) {
                return 1;
            }
            String o1DisplayName = TestEngineReflectionUtils.getDisplayName(o1);
            String o2DisplayName = TestEngineReflectionUtils.getDisplayName(o2);
            return o1DisplayName.compareTo(o2DisplayName);
        });
    }

    private static void validateDistinctOrder(List<Class<?>> classes) {
        LinkedHashMap orderToClassMap = new LinkedHashMap();
        classes.forEach(clazz -> {
            if (!clazz.isAnnotationPresent(TestEngine.BaseClass.class) && !Modifier.isAbstract(clazz.getModifiers()) && clazz.isAnnotationPresent(TestEngine.Order.class)) {
                int order = clazz.getAnnotation(TestEngine.Order.class).value();
                LOGGER.trace("clazz [%s] order [%d]", clazz.getName(), order);
                if (orderToClassMap.containsKey(order)) {
                    Class existingClass = (Class)orderToClassMap.get(order);
                    throw new TestClassConfigurationException(String.format("Test class [%s] (or superclass) and test class [%s] (or superclass) contain duplicate @TestEngine.Order(%d) class annotation", existingClass.getName(), clazz.getName(), order));
                }
                orderToClassMap.put(order, clazz);
            }
        });
    }

    public static void sortMethods(List<Method> methods) {
        methods.sort((o1, o2) -> {
            boolean o1AnnotationPresent = o1.isAnnotationPresent(TestEngine.Order.class);
            boolean o2AnnotationPresent = o2.isAnnotationPresent(TestEngine.Order.class);
            if (o1AnnotationPresent) {
                if (o2AnnotationPresent) {
                    int o1Order = o1.getAnnotation(TestEngine.Order.class).value();
                    int o2Order = o2.getAnnotation(TestEngine.Order.class).value();
                    return Integer.compare(o1Order, o2Order);
                }
                return -1;
            }
            if (o2AnnotationPresent) {
                return 1;
            }
            String o1DisplayName = TestEngineReflectionUtils.getDisplayName(o1);
            String o2DisplayName = TestEngineReflectionUtils.getDisplayName(o2);
            return o1DisplayName.compareTo(o2DisplayName);
        });
    }

    private static void validateDistinctOrder(Class<?> clazz, List<Method> methods) {
        HashSet integers = new HashSet();
        methods.forEach(method -> {
            if (method.isAnnotationPresent(TestEngine.Order.class)) {
                int value = method.getAnnotation(TestEngine.Order.class).value();
                if (integers.contains(value)) {
                    throw new TestClassConfigurationException(String.format("Test class [%s] (or superclass) contains a duplicate @TestEngine.Order(%d) method annotation", clazz.getName(), value));
                }
                integers.add(value);
            }
        });
    }

    private static String getAnnotationDisplayName(Class<? extends Annotation> annotation) {
        return String.format("@%s.%s", annotation.getDeclaringClass().getSimpleName(), annotation.getSimpleName());
    }

    static {
        prepareMethodCache = new HashMap();
        argumentFieldCaches = new HashMap();
        beforeAllMethodCache = new HashMap();
        beforeEachMethodCache = new HashMap();
        testMethodCache = new HashMap();
        afterEachMethodCache = new HashMap();
        afterAllMethodCache = new HashMap();
        concludeMethodCache = new HashMap();
    }

    private static enum Scope {
        STATIC,
        NON_STATIC;

    }
}

