/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.junit.platform.engine.ConfigurationParameters;

public final class TestEngineConfiguration
implements ConfigurationParameters {
    private static final TestEngineConfiguration INSTANCE = new TestEngineConfiguration();
    private final Map<String, String> map = new LinkedHashMap<String, String>();

    public static TestEngineConfiguration getInstance() {
        return INSTANCE;
    }

    private TestEngineConfiguration() {
    }

    @Override
    public Optional<String> get(String key) {
        return Optional.ofNullable(this.resolve(key));
    }

    @Override
    public Optional<Boolean> getBoolean(String key) {
        return Optional.ofNullable(Boolean.parseBoolean(this.resolve(key)));
    }

    @Override
    public <T> Optional<T> get(String key, Function<String, T> transformer) {
        String value = this.resolve(key);
        T t = transformer.apply(value);
        return Optional.ofNullable(t);
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    private String resolve(String key) {
        String value = this.map.get(key);
        if (value != null && !value.trim().isEmpty()) {
            return value.trim();
        }
        value = System.getenv(key.toUpperCase(Locale.ENGLISH).replace('.', '_'));
        if (value != null && !value.trim().isEmpty()) {
            return value.trim();
        }
        value = System.getProperty(key);
        if (value != null && !value.trim().isEmpty()) {
            return value.trim();
        }
        return null;
    }
}

