/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.logger;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.antublue.test.engine.internal.logger.Level;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.util.Precondition;

public final class LoggerFactory {
    private static final LoggerFactory INSTANCE = new LoggerFactory();
    private static final String ANTUBLUE_TEST_ENGINE_LOG_LEVEL = "antublue.test.engine.log.level";
    private final Map<String, Logger> loggerMap = new HashMap<String, Logger>();
    private final Level level;

    private LoggerFactory() {
        HashMap<String, Level> levelMap = new HashMap<String, Level>();
        levelMap.put("ERROR", Level.ERROR);
        levelMap.put("WARN", Level.WARN);
        levelMap.put("INFO", Level.INFO);
        levelMap.put("DEBUG", Level.DEBUG);
        levelMap.put("TRACE", Level.TRACE);
        levelMap.put("ALL", Level.ALL);
        String value = System.getenv(ANTUBLUE_TEST_ENGINE_LOG_LEVEL.toUpperCase(Locale.ENGLISH).replace('.', '_'));
        Level level = null;
        if (value != null && !value.trim().isEmpty()) {
            value = value.trim().toUpperCase(Locale.ENGLISH);
            level = (Level)levelMap.get(value);
        }
        if (level == null && (value = System.getProperty(ANTUBLUE_TEST_ENGINE_LOG_LEVEL)) != null && !value.trim().isEmpty()) {
            value = value.trim().toUpperCase(Locale.ENGLISH);
            level = (Level)levelMap.get(value);
        }
        if (level == null) {
            level = Level.INFO;
        }
        this.level = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Logger createLogger(String name) {
        LoggerFactory loggerFactory = this;
        synchronized (loggerFactory) {
            Logger logger = this.loggerMap.get(name);
            if (logger == null) {
                logger = new Logger(name, this.level);
                this.loggerMap.put(name, logger);
            }
            return logger;
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        Precondition.notNull(clazz);
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) {
        Precondition.notNull(name);
        Precondition.notBlank(name);
        return INSTANCE.createLogger(name);
    }
}

