/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Optional;
import java.util.function.Consumer;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.EngineDiscoveryErrorDescriptor;
import org.junit.platform.launcher.core.ExecutionListenerAdapter;
import org.junit.platform.launcher.core.InternalTestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryResult;
import org.junit.platform.launcher.core.ListenerRegistry;
import org.junit.platform.launcher.core.OutcomeDelayingEngineExecutionListener;
import org.junit.platform.launcher.core.StreamInterceptingTestExecutionListener;

@API(status=API.Status.INTERNAL, since="1.7", consumers={"org.junit.platform.testkit", "org.junit.platform.suite.engine"})
public class EngineExecutionOrchestrator {
    private final ListenerRegistry<TestExecutionListener> listenerRegistry;

    public EngineExecutionOrchestrator() {
        this(ListenerRegistry.forTestExecutionListeners());
    }

    EngineExecutionOrchestrator(ListenerRegistry<TestExecutionListener> listenerRegistry) {
        this.listenerRegistry = listenerRegistry;
    }

    void execute(InternalTestPlan internalTestPlan, TestExecutionListener ... listeners) {
        ConfigurationParameters configurationParameters = internalTestPlan.getConfigurationParameters();
        ListenerRegistry<TestExecutionListener> testExecutionListenerListeners = this.buildListenerRegistryForExecution(listeners);
        this.withInterceptedStreams(configurationParameters, testExecutionListenerListeners, testExecutionListener -> this.execute(internalTestPlan, EngineExecutionListener.NOOP, (TestExecutionListener)testExecutionListener));
    }

    @API(status=API.Status.INTERNAL, since="1.9", consumers={"org.junit.platform.suite.engine"})
    public void execute(LauncherDiscoveryResult discoveryResult, EngineExecutionListener engineExecutionListener, TestExecutionListener testExecutionListener) {
        Preconditions.notNull(discoveryResult, "discoveryResult must not be null");
        Preconditions.notNull(engineExecutionListener, "engineExecutionListener must not be null");
        Preconditions.notNull(testExecutionListener, "testExecutionListener must not be null");
        InternalTestPlan internalTestPlan = InternalTestPlan.from(discoveryResult);
        this.execute(internalTestPlan, engineExecutionListener, testExecutionListener);
    }

    private void execute(InternalTestPlan internalTestPlan, EngineExecutionListener parentEngineExecutionListener, TestExecutionListener testExecutionListener) {
        internalTestPlan.markStarted();
        TestPlan testPlan = internalTestPlan.getDelegate();
        LauncherDiscoveryResult discoveryResult = internalTestPlan.getDiscoveryResult();
        ListenerRegistry<EngineExecutionListener> engineExecutionListenerRegistry = ListenerRegistry.forEngineExecutionListeners();
        engineExecutionListenerRegistry.add(new ExecutionListenerAdapter(testPlan, testExecutionListener));
        engineExecutionListenerRegistry.add(parentEngineExecutionListener);
        testExecutionListener.testPlanExecutionStarted(testPlan);
        this.execute(discoveryResult, engineExecutionListenerRegistry.getCompositeListener());
        testExecutionListener.testPlanExecutionFinished(testPlan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withInterceptedStreams(ConfigurationParameters configurationParameters, ListenerRegistry<TestExecutionListener> listenerRegistry, Consumer<TestExecutionListener> action) {
        TestExecutionListener testExecutionListener = listenerRegistry.getCompositeListener();
        Optional<StreamInterceptingTestExecutionListener> streamInterceptingTestExecutionListener = StreamInterceptingTestExecutionListener.create(configurationParameters, testExecutionListener::reportingEntryPublished);
        streamInterceptingTestExecutionListener.ifPresent(listenerRegistry::add);
        try {
            action.accept(listenerRegistry.getCompositeListener());
        }
        finally {
            streamInterceptingTestExecutionListener.ifPresent(StreamInterceptingTestExecutionListener::unregister);
        }
    }

    @API(status=API.Status.INTERNAL, since="1.7", consumers={"org.junit.platform.testkit"})
    public void execute(LauncherDiscoveryResult discoveryResult, EngineExecutionListener engineExecutionListener) {
        Preconditions.notNull(discoveryResult, "discoveryResult must not be null");
        Preconditions.notNull(engineExecutionListener, "engineExecutionListener must not be null");
        for (TestEngine testEngine : discoveryResult.getTestEngines()) {
            TestDescriptor engineDescriptor = discoveryResult.getEngineTestDescriptor(testEngine);
            if (engineDescriptor instanceof EngineDiscoveryErrorDescriptor) {
                engineExecutionListener.executionStarted(engineDescriptor);
                engineExecutionListener.executionFinished(engineDescriptor, TestExecutionResult.failed(((EngineDiscoveryErrorDescriptor)engineDescriptor).getCause()));
                continue;
            }
            this.execute(engineDescriptor, engineExecutionListener, discoveryResult.getConfigurationParameters(), testEngine);
        }
    }

    private ListenerRegistry<TestExecutionListener> buildListenerRegistryForExecution(TestExecutionListener ... listeners) {
        if (listeners.length == 0) {
            return this.listenerRegistry;
        }
        return ListenerRegistry.copyOf(this.listenerRegistry).addAll((TestExecutionListener[])listeners);
    }

    private void execute(TestDescriptor engineDescriptor, EngineExecutionListener listener, ConfigurationParameters configurationParameters, TestEngine testEngine) {
        OutcomeDelayingEngineExecutionListener delayingListener = new OutcomeDelayingEngineExecutionListener(listener, engineDescriptor);
        try {
            testEngine.execute(new ExecutionRequest(engineDescriptor, delayingListener, configurationParameters));
            delayingListener.reportEngineOutcome();
        }
        catch (Throwable throwable) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(throwable);
            delayingListener.reportEngineFailure(new JUnitException(String.format("TestEngine with ID '%s' failed to execute tests", testEngine.getId()), throwable));
        }
    }
}

