/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.util.Optional;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.TestEngineExecutionContext;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ExtendedAbstractTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

public final class ArgumentTestDescriptor
extends ExtendedAbstractTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArgumentTestDescriptor.class);
    private final Class<?> testClass;
    private final Argument testArgument;

    public ArgumentTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Argument testArgument) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testArgument = testArgument;
    }

    @Override
    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from(TestEngineReflectionUtils.getArgumentSupplierMethod(this.testClass)));
    }

    @Override
    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    @Override
    public boolean isTest() {
        return false;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Argument getTestArgument() {
        return this.testArgument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TestEngineExecutionContext testEngineExecutionContext) {
        ThrowableCollector throwableCollector = this.getThrowableCollector();
        EngineExecutionListener engineExecutionListener = testEngineExecutionContext.getExecutionRequest().getEngineExecutionListener();
        engineExecutionListener.executionStarted(this);
        Object testInstance = testEngineExecutionContext.getTestInstance();
        Class<?> testClass = testInstance.getClass();
        String testClassName = testClass.getName();
        try {
            testEngineExecutionContext.setTestInstance(testInstance);
            LOGGER.trace("injecting class [%s] @TestEngine.Argument field", (Object)testClassName);
            try {
                TestEngineReflectionUtils.getArgumentField(testClass).set(testInstance, this.testArgument);
            }
            finally {
                this.flush();
            }
        }
        catch (Throwable t) {
            t = this.pruneStackTrace(t, testClassName);
            t.printStackTrace();
            throwableCollector.add(t);
        }
        if (throwableCollector.isEmpty()) {
            try {
                TestEngineReflectionUtils.getBeforeAllMethods(testClass).forEach(method -> {
                    LOGGER.trace("invoking [%s] @TestEngine.BeforeAll method [%s]", testClassName, method.getName());
                    try {
                        method.invoke(testInstance, (Object[])null);
                    }
                    finally {
                        this.flush();
                    }
                });
            }
            catch (Throwable t) {
                t = this.pruneStackTrace(t, testClassName);
                t.printStackTrace();
                throwableCollector.add(t);
            }
            if (!throwableCollector.isEmpty()) {
                this.getChildren(MethodTestDescriptor.class).forEach(methodTestDescriptor -> methodTestDescriptor.skip(testEngineExecutionContext));
            }
        } else {
            this.getChildren(MethodTestDescriptor.class).forEach(methodTestDescriptor -> methodTestDescriptor.skip(testEngineExecutionContext));
        }
        if (throwableCollector.isEmpty()) {
            this.getChildren(MethodTestDescriptor.class).forEach(methodTestDescriptor -> methodTestDescriptor.execute(testEngineExecutionContext));
        }
        try {
            TestEngineReflectionUtils.getAfterAllMethods(testClass).forEach(method -> {
                LOGGER.trace("invoking [%s] @TestEngine.AfterAll method [%s]", testClassName, method.getName());
                try {
                    method.invoke(testInstance, (Object[])null);
                }
                finally {
                    this.flush();
                }
            });
        }
        catch (Throwable t) {
            t = this.pruneStackTrace(t, testClassName);
            t.printStackTrace();
            throwableCollector.add(t);
        }
        if (throwableCollector.isEmpty()) {
            engineExecutionListener.executionFinished(this, TestExecutionResult.successful());
        } else {
            engineExecutionListener.executionFinished(this, TestExecutionResult.failed(throwableCollector.getFirst().orElse(null)));
        }
    }
}

