/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantLock;
import org.antublue.test.engine.api.Store;
import org.antublue.test.engine.api.TestEngine;

public class TestEngineLockUtils {
    private TestEngineLockUtils() {
    }

    public static void processLock(Method method) {
        String value;
        if (method.isAnnotationPresent(TestEngine.Lock.class) && (value = method.getAnnotation(TestEngine.Lock.class).value()) != null && !value.trim().isEmpty()) {
            Store.getOrCreate(value, name -> new ReentrantLock(true)).lock();
            System.out.println("DEBUG " + value + " locked " + Thread.currentThread().getName());
        }
    }

    public static void processUnlock(Method method) {
        String value;
        if (method.isAnnotationPresent(TestEngine.Unlock.class) && (value = method.getAnnotation(TestEngine.Unlock.class).value()) != null && !value.trim().isEmpty()) {
            System.out.println("DEBUG " + value + " unlocked " + Thread.currentThread().getName());
            Store.get(value, ReentrantLock.class).unlock();
        }
    }
}

