/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class Store {
    private static final Map<String, Object> OBJECT_MAP = new LinkedHashMap<String, Object>();

    private Store() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T put(String name, T value) {
        name = Store.validate(name);
        Map<String, Object> map = OBJECT_MAP;
        synchronized (map) {
            return (T)OBJECT_MAP.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T get(String name) {
        name = Store.validate(name);
        Map<String, Object> map = OBJECT_MAP;
        synchronized (map) {
            return (T)OBJECT_MAP.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T get(String name, Class<T> clazz) {
        name = Store.validate(name);
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        Map<String, Object> map = OBJECT_MAP;
        synchronized (map) {
            return clazz.cast(OBJECT_MAP.get(name));
        }
    }

    @Deprecated
    public static <T> T getOrCreate(String name, Function<String, ? extends T> function) {
        return Store.computeIfAbsent(name, function);
    }

    public static <T> T getOrElse(String name, Function<String, ? extends T> function) {
        return Store.computeIfAbsent(name, function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T computeIfAbsent(String name, Function<String, T> function) {
        name = Store.validate(name);
        if (function == null) {
            throw new IllegalArgumentException("function is null");
        }
        Map<String, Object> map = OBJECT_MAP;
        synchronized (map) {
            return (T)OBJECT_MAP.computeIfAbsent(name, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T remove(String name) {
        name = Store.validate(name);
        Map<String, Object> map = OBJECT_MAP;
        synchronized (map) {
            return (T)OBJECT_MAP.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> keySet() {
        Map<String, Object> map = OBJECT_MAP;
        synchronized (map) {
            return new LinkedHashSet<String>(OBJECT_MAP.keySet());
        }
    }

    private static String validate(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if ((name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        return name;
    }
}

