/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantLock;
import org.antublue.test.engine.api.Store;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.TestClassConfigurationException;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;

public class TestEngineLockUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngineLockUtils.class);

    private TestEngineLockUtils() {
    }

    public static void processLock(Method method) {
        String name;
        TestEngine.Lock annotation = method.getAnnotation(TestEngine.Lock.class);
        if (annotation != null && (name = annotation.value()) != null && !name.trim().isEmpty()) {
            name = name.trim();
            Store.getOrElse(name, n -> new ReentrantLock(true)).lock();
            LOGGER.trace(String.format("Lock class [%s] name [%s] locked", method.getDeclaringClass().getName(), name));
        }
    }

    public static void processUnlock(Method method) {
        String name;
        TestEngine.Unlock annotation = method.getAnnotation(TestEngine.Unlock.class);
        if (annotation != null && (name = annotation.value()) != null && !name.trim().isEmpty()) {
            ReentrantLock reentrantLock = (ReentrantLock)Store.get(name = name.trim());
            if (reentrantLock != null) {
                LOGGER.trace(String.format("Lock class [%s] name [%s] unlocked", method.getDeclaringClass().getName(), name));
                reentrantLock.unlock();
            } else {
                throw new TestClassConfigurationException(String.format("@TestEngine.Unlock with out @TestEngine.Lock, class [%s]", method.getDeclaringClass().getName()));
            }
        }
    }
}

