/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.util.Arrays;
import org.junit.jupiter.api.condition.AbstractOsBasedExecutionCondition;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.platform.commons.util.Preconditions;

class EnabledOnOsCondition
extends AbstractOsBasedExecutionCondition<EnabledOnOs> {
    EnabledOnOsCondition() {
        super(EnabledOnOs.class);
    }

    @Override
    ConditionEvaluationResult evaluateExecutionCondition(EnabledOnOs annotation) {
        boolean osSpecified = annotation.value().length > 0;
        boolean archSpecified = annotation.architectures().length > 0;
        Preconditions.condition(osSpecified || archSpecified, "You must declare at least one OS or architecture in @EnabledOnOs");
        boolean enabled = this.isEnabledBasedOnOs(annotation) && this.isEnabledBasedOnArchitecture(annotation);
        String reason = this.createReason(enabled, osSpecified, archSpecified);
        return enabled ? ConditionEvaluationResult.enabled(reason) : ConditionEvaluationResult.disabled(reason, annotation.disabledReason());
    }

    private boolean isEnabledBasedOnOs(EnabledOnOs annotation) {
        OS[] operatingSystems = annotation.value();
        if (operatingSystems.length == 0) {
            return true;
        }
        return Arrays.stream(operatingSystems).anyMatch(OS::isCurrentOs);
    }

    private boolean isEnabledBasedOnArchitecture(EnabledOnOs annotation) {
        String[] architectures = annotation.architectures();
        if (architectures.length == 0) {
            return true;
        }
        return Arrays.stream(architectures).anyMatch(CURRENT_ARCHITECTURE::equalsIgnoreCase);
    }
}

