/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.antublue.test.engine.TestEngine;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.TestEngineConfiguration;
import org.antublue.test.engine.internal.TestEngineTestDescriptorStore;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ExtendedEngineDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.TestDescriptorUtils;
import org.antublue.test.engine.internal.util.AnsiColor;
import org.antublue.test.engine.internal.util.AnsiColorString;
import org.antublue.test.engine.internal.util.HumanReadableTime;
import org.antublue.test.engine.internal.util.Switch;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class TestEngineConsoleTestExecutionListener
implements TestExecutionListener {
    private static final String BANNER = new AnsiColorString().color(AnsiColor.WHITE_BRIGHT).append("Antu").color(AnsiColor.BLUE_BOLD_BRIGHT).append("BLUE").color(AnsiColor.WHITE_BRIGHT).append(" Test Engine ").append(TestEngine.VERSION).toString();
    private static final String SUMMARY_BANNER = BANNER + AnsiColor.WHITE_BRIGHT.apply(" Summary");
    private static final String INFO = new AnsiColorString().color(AnsiColor.WHITE_BRIGHT).append("[").color(AnsiColor.BLUE_BOLD).append("INFO").color(AnsiColor.WHITE_BRIGHT).append("] ").toString();
    private static final String TEST = AnsiColor.WHITE_BRIGHT.apply("TEST");
    private static final String PASS = AnsiColor.GREEN_BOLD_BRIGHT.apply("PASS");
    private static final String SKIP = AnsiColor.YELLOW_BOLD_BRIGHT.apply("SKIP");
    private static final String FAIL = AnsiColor.RED_BOLD_BRIGHT.apply("FAIL");
    private static final String SEPARATOR = AnsiColor.WHITE_BRIGHT.apply("------------------------------------------------------------------------");
    private final Summary summary = new Summary();
    private final boolean detailedOutput = TestEngineConfiguration.getInstance().get("antublue.test.engine.console.output").map(value -> {
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            return true;
        }
    }).orElse(true);
    private final boolean logTestMessages = TestEngineConfiguration.getInstance().get("antublue.test.engine.experimental.log.test.messages").map(value -> {
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            return true;
        }
    }).orElse(true);
    private final boolean logPassMessages = TestEngineConfiguration.getInstance().get("antublue.test.engine.experimental.log.pass.messages").map(value -> {
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            return true;
        }
    }).orElse(true);
    private final boolean logSkipMessages = TestEngineConfiguration.getInstance().get("antublue.test.engine.experimental.log.skip.messages").map(value -> {
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            return true;
        }
    }).orElse(true);

    public boolean hasFailures() {
        if (this.summary.getTestClassCount() == 0L) {
            return true;
        }
        return this.summary.getTestClassesFailedCount() + this.summary.getArgumentsFailedCount() + this.summary.getTestsFailedCount() > 0L;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.summary.testPlanExecutionStarted(testPlan);
        testPlan.getRoots().forEach(testIdentifier -> TestEngineTestDescriptorStore.getInstance().get(testIdentifier.getUniqueIdObject()).ifPresent(TestDescriptorUtils::logTestDescriptorTree));
        System.out.println(INFO + SEPARATOR);
        System.out.println(INFO + BANNER);
        System.out.println(INFO + SEPARATOR);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        TestDescriptor testDescriptor = TestEngineTestDescriptorStore.getInstance().get(testIdentifier.getUniqueIdObject()).orElse(null);
        this.summary.executionStarted(testDescriptor);
        StringBuilder stringBuilder = new StringBuilder();
        Switch.switchType(testDescriptor, Switch.switchCase(ExtendedEngineDescriptor.class, consumer -> {}), Switch.switchCase(ClassTestDescriptor.class, consumer -> {
            ClassTestDescriptor classTestDescriptor = (ClassTestDescriptor)testDescriptor;
            Class<?> testClass = classTestDescriptor.getTestClass();
            if (this.logTestMessages) {
                stringBuilder.append(TEST).append(" | ").append(testClass.getName());
            }
        }), Switch.switchCase(ArgumentTestDescriptor.class, consumer -> {
            if (this.logTestMessages) {
                ArgumentTestDescriptor argumentTestDescriptor = (ArgumentTestDescriptor)testDescriptor;
                Class<?> testClass = argumentTestDescriptor.getTestClass();
                Argument testArgument = argumentTestDescriptor.getTestArgument();
                String testArgumentName = testArgument.name();
                stringBuilder.append(TEST).append(" | ").append(testArgumentName).append(" | ").append(testClass.getName());
            }
        }), Switch.switchCase(MethodTestDescriptor.class, consumer -> {
            if (this.logTestMessages) {
                MethodTestDescriptor methodTestDescriptor = (MethodTestDescriptor)testDescriptor;
                Class<?> testClass = methodTestDescriptor.getTestClass();
                Method testMethod = methodTestDescriptor.getTestMethod();
                Argument testArgument = methodTestDescriptor.getTestArgument();
                String testArgumentName = testArgument.name();
                stringBuilder.append(TEST).append(" | ").append(testArgumentName).append(" | ").append(testClass.getName()).append(" ").append(testMethod.getName()).append("()");
            }
        }));
        if (this.detailedOutput && stringBuilder.length() > 0) {
            System.out.println(INFO + Thread.currentThread().getName() + " | " + stringBuilder);
        }
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        TestDescriptor testDescriptor = TestEngineTestDescriptorStore.getInstance().get(testIdentifier.getUniqueIdObject()).orElse(null);
        this.summary.executionSkipped(testDescriptor, reason);
        StringBuilder stringBuilder = new StringBuilder();
        Switch.switchType(testDescriptor, Switch.switchCase(ExtendedEngineDescriptor.class, consumer -> {}), Switch.switchCase(ClassTestDescriptor.class, consumer -> {
            if (this.logSkipMessages) {
                ClassTestDescriptor classTestDescriptor = (ClassTestDescriptor)testDescriptor;
                Class<?> testClass = classTestDescriptor.getTestClass();
                stringBuilder.append(SKIP).append(" | ").append(testClass.getName());
            }
        }), Switch.switchCase(ArgumentTestDescriptor.class, consumer -> {
            if (this.logSkipMessages) {
                ArgumentTestDescriptor argumentTestDescriptor = (ArgumentTestDescriptor)testDescriptor;
                Class<?> testClass = argumentTestDescriptor.getTestClass();
                Argument testArgument = argumentTestDescriptor.getTestArgument();
                String testArgumentName = testArgument.name();
                stringBuilder.append(SKIP).append(" | ").append(testArgumentName).append(" | ").append(testClass.getName());
            }
        }), Switch.switchCase(MethodTestDescriptor.class, consumer -> {
            if (this.logSkipMessages) {
                MethodTestDescriptor methodTestDescriptor = (MethodTestDescriptor)testDescriptor;
                Class<?> testClass = methodTestDescriptor.getTestClass();
                Method testMethod = methodTestDescriptor.getTestMethod();
                Argument testArgument = methodTestDescriptor.getTestArgument();
                String testArgumentName = testArgument.name();
                stringBuilder.append(SKIP).append(" | ").append(testArgumentName).append(" | ").append(testClass.getName()).append(" ").append(testMethod.getName()).append("()");
            }
        }));
        if (this.detailedOutput && stringBuilder.length() > 0) {
            System.out.println(INFO + Thread.currentThread().getName() + " | " + stringBuilder);
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        TestDescriptor testDescriptor = TestEngineTestDescriptorStore.getInstance().get(testIdentifier.getUniqueIdObject()).orElse(null);
        this.summary.executionFinished(testDescriptor, testExecutionResult);
        StringBuilder stringBuilder = new StringBuilder();
        Switch.switchType(testDescriptor, Switch.switchCase(ExtendedEngineDescriptor.class, consumer -> {}), Switch.switchCase(ClassTestDescriptor.class, consumer -> {
            if (this.logPassMessages) {
                ClassTestDescriptor classTestDescriptor = (ClassTestDescriptor)testDescriptor;
                Class<?> testClass = classTestDescriptor.getTestClass();
                stringBuilder.append("%s | ").append(testClass.getName());
            }
        }), Switch.switchCase(ArgumentTestDescriptor.class, consumer -> {
            if (this.logPassMessages) {
                ArgumentTestDescriptor argumentTestDescriptor = (ArgumentTestDescriptor)testDescriptor;
                Class<?> testClass = argumentTestDescriptor.getTestClass();
                Argument testArgument = argumentTestDescriptor.getTestArgument();
                String testArgumentName = testArgument.name();
                stringBuilder.append("%s | ").append(testArgumentName).append(" | ").append(testClass.getName());
            }
        }), Switch.switchCase(MethodTestDescriptor.class, consumer -> {
            if (this.logPassMessages) {
                MethodTestDescriptor methodTestDescriptor = (MethodTestDescriptor)testDescriptor;
                Class<?> testClass = methodTestDescriptor.getTestClass();
                Method testMethod = methodTestDescriptor.getTestMethod();
                Argument testArgument = methodTestDescriptor.getTestArgument();
                String testArgumentName = testArgument.name();
                stringBuilder.append("%s | ").append(testArgumentName).append(" | ").append(testClass.getName()).append(" ").append(testMethod.getName()).append("()");
            }
        }));
        if (stringBuilder.length() > 0) {
            TestExecutionResult.Status status = testExecutionResult.getStatus();
            String string = null;
            switch (status) {
                case ABORTED: {
                    string = String.format(stringBuilder.toString(), SKIP);
                    break;
                }
                case FAILED: {
                    string = String.format(stringBuilder.toString(), FAIL);
                    break;
                }
                case SUCCESSFUL: {
                    string = String.format(stringBuilder.toString(), PASS);
                    break;
                }
            }
            if (this.detailedOutput && string != null) {
                System.out.println(INFO + Thread.currentThread().getName() + " | " + string);
            }
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.summary.testPlanExecutionFinished(testPlan);
        System.out.println(INFO + SEPARATOR);
        System.out.println(INFO + SUMMARY_BANNER);
        System.out.println(INFO + SEPARATOR);
        if (this.summary.getTestClassCount() != 0L) {
            long column1Width = this.getColumnWith(this.summary.getTestClassCount(), this.summary.getArgumentsFoundCount(), this.summary.getTestsFoundCount());
            long column2Width = this.getColumnWith(this.summary.getTestClassesSucceededCount(), this.summary.getArgumentsSucceededCount(), this.summary.getTestsSucceededCount());
            long column3Width = this.getColumnWith(this.summary.getTestClassesFailedCount(), this.summary.getArgumentsFailedCount(), this.summary.getTestsFailedCount());
            long column4Width = this.getColumnWith(this.summary.getTestClassesSkippedCount(), this.summary.getArgumentsSkippedCount(), this.summary.getTestsSkippedCount());
            AnsiColorString ansiColorString = new AnsiColorString();
            ansiColorString.append(INFO).color(AnsiColor.WHITE_BRIGHT).append("Test Classes").append(" : ").append(this.pad(this.summary.getTestClassCount(), column1Width)).append(", ").color(AnsiColor.GREEN_BOLD_BRIGHT).append("PASSED").color(AnsiColor.WHITE_BRIGHT).append(" : ").append(this.pad(this.summary.getTestClassesSucceededCount(), column2Width)).append(", ").color(AnsiColor.RED_BOLD_BRIGHT).append("FAILED").color(AnsiColor.WHITE_BRIGHT).append(" : ").append(this.pad(this.summary.getTestClassesFailedCount(), column3Width)).append(", ").color(AnsiColor.YELLOW_BOLD_BRIGHT).append("SKIPPED").color(AnsiColor.WHITE_BRIGHT).append(" : ").append(this.pad(this.summary.getTestClassesSkippedCount(), column4Width));
            System.out.println(ansiColorString);
            ansiColorString.append(INFO).color(AnsiColor.WHITE_BRIGHT).append("Test Methods").append(" : ").append(this.pad(this.summary.getTestsFoundCount(), column1Width)).append(", ").color(AnsiColor.GREEN_BOLD_BRIGHT).append("PASSED").color(AnsiColor.WHITE_BRIGHT).append(" : ").append(this.pad(this.summary.getTestsSucceededCount(), column2Width)).append(", ").color(AnsiColor.RED_BOLD_BRIGHT).append("FAILED").color(AnsiColor.WHITE_BRIGHT).append(" : ").append(this.pad(this.summary.getTestsFailedCount(), column3Width)).append(", ").color(AnsiColor.YELLOW_BOLD_BRIGHT).append("SKIPPED").color(AnsiColor.WHITE_BRIGHT).append(" : ").append(this.pad(this.summary.getTestsSkippedCount(), column4Width));
            System.out.println(ansiColorString);
        } else {
            System.out.println(INFO + AnsiColor.RED_BOLD_BRIGHT.apply("NO TESTS FOUND"));
        }
        System.out.println(INFO + SEPARATOR);
        if (this.hasFailures()) {
            System.out.println(INFO + AnsiColor.RED_BOLD_BRIGHT.apply("FAILED"));
        } else {
            System.out.println(INFO + AnsiColor.GREEN_BOLD_BRIGHT.apply("PASSED"));
        }
        long elapsedTime = this.summary.getTimeFinished() - this.summary.getTimeStarted();
        System.out.println(INFO + SEPARATOR);
        System.out.println(INFO + AnsiColor.WHITE_BRIGHT.apply("Total Test Time : " + HumanReadableTime.toHumanReadable(elapsedTime, false) + " (" + elapsedTime + " ms)"));
        System.out.println(INFO + AnsiColor.WHITE_BRIGHT.apply("Finished At     : " + HumanReadableTime.now()));
        if (!this.hasFailures()) {
            System.out.println(INFO + SEPARATOR);
        }
    }

    private long getColumnWith(long ... values) {
        long width = 0L;
        for (long value : values) {
            width = Math.max((long)String.valueOf(value).length(), width);
        }
        return width;
    }

    private String pad(long value, long width) {
        String stringValue = String.valueOf(value);
        StringBuilder paddingStringBuilder = new StringBuilder();
        while ((long)(paddingStringBuilder.length() + stringValue.length()) < width) {
            paddingStringBuilder.append(" ");
        }
        return paddingStringBuilder.append(stringValue).toString();
    }

    private static class Summary {
        private long startMilliseconds;
        private long finishedMilliseconds;
        private final Set<Class<?>> testClasses = Collections.synchronizedSet(new HashSet());
        private final AtomicLong testClassesFound = new AtomicLong();
        private final AtomicLong testClassesSuccess = new AtomicLong();
        private final AtomicLong testClassesFailed = new AtomicLong();
        private final AtomicLong testClassesSkipped = new AtomicLong();
        private final AtomicLong argumentsFound = new AtomicLong();
        private final AtomicLong argumentsSuccess = new AtomicLong();
        private final AtomicLong argumentsFailed = new AtomicLong();
        private final AtomicLong argumentsSkipped = new AtomicLong();
        private final AtomicLong methodsFound = new AtomicLong();
        private final AtomicLong methodsSuccess = new AtomicLong();
        private final AtomicLong methodsFailed = new AtomicLong();
        private final AtomicLong methodsSkipped = new AtomicLong();

        public long getTimeStarted() {
            return this.startMilliseconds;
        }

        public long getTestClassCount() {
            return this.testClassesFound.get();
        }

        public long getTestClassesSucceededCount() {
            return this.testClassesSuccess.get();
        }

        public long getTestClassesFailedCount() {
            return this.testClassesFailed.get();
        }

        public long getTestClassesSkippedCount() {
            return this.testClassesSkipped.get();
        }

        public long getArgumentsFoundCount() {
            return this.argumentsFound.get();
        }

        public long getArgumentsSucceededCount() {
            return this.argumentsSuccess.get();
        }

        public long getArgumentsFailedCount() {
            return this.argumentsFailed.get();
        }

        public long getArgumentsSkippedCount() {
            return this.argumentsSkipped.get();
        }

        public long getTestsFoundCount() {
            return this.methodsFound.get();
        }

        public long getTestsSucceededCount() {
            return this.methodsSuccess.get();
        }

        public long getTestsFailedCount() {
            return this.methodsFailed.get();
        }

        public long getTestsSkippedCount() {
            return this.methodsSkipped.get();
        }

        public long getTimeFinished() {
            return this.finishedMilliseconds;
        }

        public void testPlanExecutionStarted(TestPlan testPlan) {
            this.finishedMilliseconds = this.startMilliseconds = System.currentTimeMillis();
        }

        public void executionStarted(TestDescriptor testDescriptor) {
            if (testDescriptor instanceof ClassTestDescriptor) {
                this.testClasses.add(((ClassTestDescriptor)testDescriptor).getTestClass());
                this.testClassesFound.set(this.testClasses.size());
                return;
            }
            if (testDescriptor instanceof ArgumentTestDescriptor) {
                this.argumentsFound.incrementAndGet();
                return;
            }
            if (testDescriptor instanceof MethodTestDescriptor) {
                this.methodsFound.incrementAndGet();
            }
        }

        public void executionSkipped(TestDescriptor testDescriptor, String reason) {
            if (testDescriptor instanceof ArgumentTestDescriptor) {
                this.argumentsFound.incrementAndGet();
                this.argumentsSkipped.incrementAndGet();
                return;
            }
            if (testDescriptor instanceof MethodTestDescriptor) {
                this.methodsFound.incrementAndGet();
                this.methodsSkipped.incrementAndGet();
            }
        }

        public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
            TestExecutionResult.Status status;
            if (testDescriptor instanceof ClassTestDescriptor) {
                TestExecutionResult.Status status2 = testExecutionResult.getStatus();
                switch (status2) {
                    case SUCCESSFUL: {
                        this.testClassesSuccess.incrementAndGet();
                        break;
                    }
                    case FAILED: {
                        this.testClassesFailed.incrementAndGet();
                        break;
                    }
                    case ABORTED: {
                        this.testClassesSkipped.incrementAndGet();
                    }
                }
                return;
            }
            if (testDescriptor instanceof ArgumentTestDescriptor) {
                status = testExecutionResult.getStatus();
                switch (status) {
                    case SUCCESSFUL: {
                        this.argumentsSuccess.incrementAndGet();
                        break;
                    }
                    case FAILED: {
                        this.argumentsFailed.incrementAndGet();
                        break;
                    }
                    case ABORTED: {
                        this.argumentsSkipped.incrementAndGet();
                    }
                }
            }
            if (testDescriptor instanceof MethodTestDescriptor) {
                status = testExecutionResult.getStatus();
                switch (status) {
                    case SUCCESSFUL: {
                        this.methodsSuccess.incrementAndGet();
                        break;
                    }
                    case FAILED: {
                        this.methodsFailed.incrementAndGet();
                        break;
                    }
                    case ABORTED: {
                        this.methodsSkipped.incrementAndGet();
                    }
                }
            }
        }

        public void testPlanExecutionFinished(TestPlan testPlan) {
            this.finishedMilliseconds = System.currentTimeMillis();
        }
    }
}

