/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.TestClassConfigurationException;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;

public class TestEngineLockUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngineLockUtils.class);
    private static final Map<String, ReentrantReadWriteLock> LOCK_MAP = Collections.synchronizedMap(new HashMap());

    private TestEngineLockUtils() {
    }

    public static void processLock(Method method) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = method.getAnnotations()) {
            Annotation lockListAnnotation;
            Annotation lockAnnotation;
            if (annotation.annotationType().isAssignableFrom(TestEngine.Lock.class)) {
                lockAnnotation = (TestEngine.Lock)annotation;
                TestEngineLockUtils.lock(method, lockAnnotation.value(), lockAnnotation.mode());
                continue;
            }
            if (annotation.annotationType().isAssignableFrom(TestEngine.Lock.List.class)) {
                lockListAnnotation = (TestEngine.Lock.List)annotation;
                Stream.of(lockListAnnotation.value()).forEach(lock -> TestEngineLockUtils.lock(method, lock.value(), lock.mode()));
                continue;
            }
            if (annotation.annotationType().isAssignableFrom(TestEngine.ResourceLock.class)) {
                lockAnnotation = (TestEngine.ResourceLock)annotation;
                TestEngineLockUtils.lock(method, lockAnnotation.value(), lockAnnotation.mode());
                continue;
            }
            if (!annotation.annotationType().isAssignableFrom(TestEngine.ResourceLock.List.class)) continue;
            lockListAnnotation = (TestEngine.ResourceLock.List)annotation;
            Stream.of(lockListAnnotation.value()).forEach(lock -> TestEngineLockUtils.lock(method, lock.value(), lock.mode()));
        }
    }

    private static void lock(Method method, String name, TestEngine.LockMode mode) {
        if (name != null && !name.trim().isEmpty()) {
            name = name.trim();
            if (mode == TestEngine.LockMode.READ_WRITE) {
                LOCK_MAP.computeIfAbsent(name, n -> new ReentrantReadWriteLock(true)).writeLock().lock();
            } else {
                LOCK_MAP.computeIfAbsent(name, n -> new ReentrantReadWriteLock(true)).readLock().lock();
            }
            LOGGER.trace(String.format("Locking [%s] mode [%s] for class [%s] method [%s]", new Object[]{name, mode, method.getDeclaringClass().getName(), method.getName()}));
        }
    }

    public static void processUnlock(Method method) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = method.getAnnotations()) {
            Annotation lockListAnnotation;
            Annotation lockAnnotation;
            if (annotation.annotationType().isAssignableFrom(TestEngine.Lock.class)) {
                lockAnnotation = (TestEngine.Lock)annotation;
                TestEngineLockUtils.unlock(method, lockAnnotation.value(), lockAnnotation.mode());
                continue;
            }
            if (annotation.annotationType().isAssignableFrom(TestEngine.Lock.List.class)) {
                lockListAnnotation = (TestEngine.Lock.List)annotation;
                Stream.of(lockListAnnotation.value()).forEach(lock -> TestEngineLockUtils.unlock(method, lock.value(), lock.mode()));
                continue;
            }
            if (annotation.annotationType().isAssignableFrom(TestEngine.ResourceLock.class)) {
                lockAnnotation = (TestEngine.ResourceLock)annotation;
                TestEngineLockUtils.unlock(method, lockAnnotation.value(), lockAnnotation.mode());
                continue;
            }
            if (!annotation.annotationType().isAssignableFrom(TestEngine.ResourceLock.List.class)) continue;
            lockListAnnotation = (TestEngine.ResourceLock.List)annotation;
            List<TestEngine.ResourceLock> list = Arrays.asList(lockListAnnotation.value());
            Collections.reverse(list);
            list.stream().forEach(lock -> TestEngineLockUtils.unlock(method, lock.value(), lock.mode()));
        }
    }

    private static void unlock(Method method, String name, TestEngine.LockMode mode) {
        if (name != null && !name.trim().isEmpty()) {
            ReentrantReadWriteLock reentrantReadWriteLock = LOCK_MAP.get(name = name.trim());
            if (reentrantReadWriteLock != null) {
                LOGGER.trace(String.format("Unlocking [%s] mode [%s] for class [%s] method [%s]", new Object[]{name, mode, method.getDeclaringClass().getName(), method.getName()}));
                if (mode == TestEngine.LockMode.READ_WRITE) {
                    reentrantReadWriteLock.writeLock().unlock();
                } else {
                    reentrantReadWriteLock.readLock().unlock();
                }
            } else {
                throw new TestClassConfigurationException(String.format("@TestEngine.Unlock without @TestEngine.Lock, class [%s] method [%s]", method.getDeclaringClass().getName(), method.getName()));
            }
        }
    }
}

