/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery.resolver;

import java.util.List;
import java.util.function.Predicate;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.discovery.ClassNameFilter;

public class ClassNameFiltersPredicate
implements Predicate<Class<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassNameFiltersPredicate.class);
    private final List<ClassNameFilter> classNameFilters;

    public ClassNameFiltersPredicate(List<ClassNameFilter> classNameFilters) {
        this.classNameFilters = classNameFilters;
    }

    @Override
    public boolean test(Class<?> clazz) {
        if (this.classNameFilters == null || this.classNameFilters.isEmpty()) {
            LOGGER.trace("class [%s] included", (Object)clazz.getName());
            return true;
        }
        for (ClassNameFilter classNameFilter : this.classNameFilters) {
            FilterResult filterResult = classNameFilter.apply((Object)clazz.getName());
            if (!filterResult.excluded()) continue;
            LOGGER.trace("class [%s] excluded", (Object)clazz.getName());
            return false;
        }
        LOGGER.trace("class [%s] included", (Object)clazz.getName());
        return true;
    }
}

