/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine;

import java.util.Optional;
import org.antublue.test.engine.internal.TestClassConfigurationException;
import org.antublue.test.engine.internal.TestEngineConfiguration;
import org.antublue.test.engine.internal.TestEngineEngineDiscoveryRequest;
import org.antublue.test.engine.internal.TestEngineException;
import org.antublue.test.engine.internal.TestEngineExecutor;
import org.antublue.test.engine.internal.TestEngineInformation;
import org.antublue.test.engine.internal.TestEngineTestDescriptorStore;
import org.antublue.test.engine.internal.descriptor.ExtendedEngineDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

public class TestEngine
implements org.junit.platform.engine.TestEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngine.class);
    public static final String ENGINE_ID = "antublue-test-engine";
    public static final String GROUP_ID = "org.antublue";
    public static final String ARTIFACT_ID = "test-engine";
    public static final String VERSION = TestEngineInformation.getVersion();
    public static final String ANTUBLUE_TEST_ENGINE_MAVEN_PLUGIN = "__ANTUBLUE_TEST_ENGINE_MAVEN_PLUGIN__";
    public static final String ANTUBLUE_TEST_ENGINE_MAVEN_BATCH_MODE = "__ANTUBLUE_TEST_ENGINE_MAVEN_BATCH_MODE__";

    public String getId() {
        return ENGINE_ID;
    }

    public Optional<String> getGroupId() {
        return Optional.of(GROUP_ID);
    }

    public Optional<String> getArtifactId() {
        return Optional.of(ARTIFACT_ID);
    }

    public Optional<String> getVersion() {
        return Optional.of(VERSION);
    }

    public TestDescriptor discover(EngineDiscoveryRequest engineDiscoveryRequest, UniqueId uniqueId) {
        LOGGER.trace("discover()");
        ExtendedEngineDescriptor extendedEngineDescriptor = null;
        try {
            extendedEngineDescriptor = new ExtendedEngineDescriptor(UniqueId.forEngine((String)this.getId()), this.getId());
            TestEngineEngineDiscoveryRequest testEngineDiscoveryRequest = new TestEngineEngineDiscoveryRequest(engineDiscoveryRequest, TestEngineConfiguration.getInstance(), extendedEngineDescriptor);
            testEngineDiscoveryRequest.resolve();
            TestEngineTestDescriptorStore.getInstance().store(extendedEngineDescriptor);
        }
        catch (TestClassConfigurationException | TestEngineException t) {
            if ("true".equals(System.getProperty(ANTUBLUE_TEST_ENGINE_MAVEN_PLUGIN))) {
                throw t;
            }
            System.err.println(t.getMessage());
            System.exit(1);
        }
        return extendedEngineDescriptor;
    }

    public void execute(ExecutionRequest executionRequest) {
        LOGGER.trace("execute()");
        new TestEngineExecutor().execute(executionRequest);
    }
}

