/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.antublue.test.engine.internal.TestEngineConfiguration;
import org.antublue.test.engine.internal.TestEngineException;
import org.antublue.test.engine.internal.TestEngineExecutionContext;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ExtendedEngineDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.NamedThreadFactory;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;

public class TestEngineExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngineExecutor.class);
    private final ExecutorService executorService;

    public TestEngineExecutor() {
        int threadCount = TestEngineConfiguration.getInstance().get("antublue.test.engine.thread.count").map(value -> {
            try {
                int intValue = Integer.parseInt(value);
                if (intValue >= 1) {
                    return intValue;
                }
                throw new TestEngineException(String.format("Invalid thread count [%d]", intValue));
            }
            catch (NumberFormatException e) {
                throw new TestEngineException(String.format("Invalid thread count [%s]", value), e);
            }
        }).orElse(Runtime.getRuntime().availableProcessors());
        LOGGER.trace("[%s] = [%d]", "antublue.test.engine.thread.count", threadCount);
        this.executorService = new ThreadPoolExecutor(threadCount, threadCount, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(threadCount * 10), new NamedThreadFactory("test-engine-%02d"), new BlockingRejectedExecutionHandler());
    }

    public void execute(ExecutionRequest executionRequest) {
        LOGGER.trace("execute()");
        ExtendedEngineDescriptor extendedEngineDescriptor = (ExtendedEngineDescriptor)executionRequest.getRootTestDescriptor();
        executionRequest.getEngineExecutionListener().executionStarted((TestDescriptor)extendedEngineDescriptor);
        List<ClassTestDescriptor> classTestDescriptors = extendedEngineDescriptor.getChildren(ClassTestDescriptor.class);
        CountDownLatch countDownLatch = new CountDownLatch(classTestDescriptors.size());
        classTestDescriptors.forEach(classTestDescriptor -> this.executorService.submit(new ClassTestDescriptorRunnable((ClassTestDescriptor)((Object)classTestDescriptor), new TestEngineExecutionContext(executionRequest, countDownLatch))));
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new TestEngineException("Test execution interrupted");
        }
        finally {
            if (this.executorService != null) {
                this.executorService.shutdown();
            }
        }
        executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)extendedEngineDescriptor, TestExecutionResult.successful());
    }

    private static class BlockingRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private BlockingRejectedExecutionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            if (!executor.isShutdown()) {
                try {
                    executor.getQueue().put(runnable);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Runnable discarded!!!");
                }
            }
        }
    }

    private static final class ClassTestDescriptorRunnable
    implements Runnable {
        private final ClassTestDescriptor classTestDescriptor;
        private final TestEngineExecutionContext testEngineExecutionContext;

        public ClassTestDescriptorRunnable(ClassTestDescriptor classTestDescriptor, TestEngineExecutionContext testEngineExecutionContext) {
            this.testEngineExecutionContext = testEngineExecutionContext;
            this.classTestDescriptor = classTestDescriptor;
        }

        @Override
        public void run() {
            try {
                this.classTestDescriptor.execute(this.testEngineExecutionContext);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

