/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.Optional;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.TestEngineExecutionContext;
import org.antublue.test.engine.internal.TestEngineLockUtils;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ExtendedAbstractTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

public final class ArgumentTestDescriptor
extends ExtendedAbstractTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArgumentTestDescriptor.class);
    private final Class<?> testClass;
    private final Argument testArgument;

    ArgumentTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Argument testArgument) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testArgument = testArgument;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)TestEngineReflectionUtils.getArgumentSupplierMethod(this.testClass)));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public boolean isTest() {
        return false;
    }

    public boolean isContainer() {
        return true;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Argument getTestArgument() {
        return this.testArgument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TestEngineExecutionContext testEngineExecutionContext) {
        ThrowableCollector throwableCollector = this.getThrowableCollector();
        EngineExecutionListener engineExecutionListener = testEngineExecutionContext.getExecutionRequest().getEngineExecutionListener();
        engineExecutionListener.executionStarted((TestDescriptor)this);
        Object testInstance = testEngineExecutionContext.getTestInstance();
        Class<?> testClass = testInstance.getClass();
        String testClassName = testClass.getName();
        try {
            testEngineExecutionContext.setTestInstance(testInstance);
            try {
                LOGGER.trace("injecting test instance [%s] @TestEngine.Argument field", (Object)testClassName);
                TestEngineReflectionUtils.getArgumentField(testClass).set(testInstance, this.testArgument);
            }
            finally {
                this.flush();
            }
        }
        catch (Throwable t) {
            t = this.pruneStackTrace(t, testClassName);
            t.printStackTrace();
            throwableCollector.add(t);
        }
        if (throwableCollector.isEmpty()) {
            try {
                TestEngineReflectionUtils.getBeforeAllMethods(testClass).forEach(method -> {
                    LOGGER.trace("invoking test instance [%s] @TestEngine.BeforeAll method [%s]", testClassName, method.getName());
                    try {
                        TestEngineLockUtils.processLockAnnotations(method);
                        method.invoke(testInstance, (Object[])null);
                    }
                    finally {
                        TestEngineLockUtils.processUnlockAnnotations(method);
                        this.flush();
                    }
                });
            }
            catch (Throwable t) {
                t = this.pruneStackTrace(t, testClassName);
                t.printStackTrace();
                throwableCollector.add(t);
            }
            if (!throwableCollector.isEmpty()) {
                this.getChildren(MethodTestDescriptor.class).forEach(methodTestDescriptor -> methodTestDescriptor.skip(testEngineExecutionContext));
            }
        } else {
            this.getChildren(MethodTestDescriptor.class).forEach(methodTestDescriptor -> methodTestDescriptor.skip(testEngineExecutionContext));
        }
        if (throwableCollector.isEmpty()) {
            this.getChildren(MethodTestDescriptor.class).forEach(methodTestDescriptor -> methodTestDescriptor.execute(testEngineExecutionContext));
        }
        try {
            TestEngineReflectionUtils.getAfterAllMethods(testClass).forEach(method -> {
                LOGGER.trace("invoking test instance [%s] @TestEngine.AfterAll method [%s]", testClassName, method.getName());
                try {
                    TestEngineLockUtils.processLockAnnotations(method);
                    method.invoke(testInstance, (Object[])null);
                }
                finally {
                    TestEngineLockUtils.processUnlockAnnotations(method);
                    this.flush();
                }
            });
        }
        catch (Throwable t) {
            t = this.pruneStackTrace(t, testClassName);
            t.printStackTrace();
            throwableCollector.add(t);
        }
        try {
            TestEngineReflectionUtils.getArgumentField(testClass).set(testInstance, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (throwableCollector.isEmpty()) {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)throwableCollector.getFirst().orElse(null)));
        }
    }
}

